/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ObjectFieldSelector {
    @Nullable
    private String apiVersion;
    private String fieldPath;

    private ObjectFieldSelector() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public String fieldPath() {
        return this.fieldPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ObjectFieldSelector defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        private String fieldPath;

        public Builder() {
        }

        public Builder(ObjectFieldSelector defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.fieldPath = defaults.fieldPath;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder fieldPath(String fieldPath) {
            if (fieldPath == null) {
                throw new MissingRequiredPropertyException("ObjectFieldSelector", "fieldPath");
            }
            this.fieldPath = fieldPath;
            return this;
        }

        public ObjectFieldSelector build() {
            ObjectFieldSelector _resultValue = new ObjectFieldSelector();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.fieldPath = this.fieldPath;
            return _resultValue;
        }
    }
}

