/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ObjectReference {
    @Nullable
    private String apiVersion;
    @Nullable
    private String fieldPath;
    @Nullable
    private String kind;
    @Nullable
    private String name;
    @Nullable
    private String namespace;
    @Nullable
    private String resourceVersion;
    @Nullable
    private String uid;

    private ObjectReference() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<String> fieldPath() {
        return Optional.ofNullable(this.fieldPath);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> namespace() {
        return Optional.ofNullable(this.namespace);
    }

    public Optional<String> resourceVersion() {
        return Optional.ofNullable(this.resourceVersion);
    }

    public Optional<String> uid() {
        return Optional.ofNullable(this.uid);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ObjectReference defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        @Nullable
        private String fieldPath;
        @Nullable
        private String kind;
        @Nullable
        private String name;
        @Nullable
        private String namespace;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String uid;

        public Builder() {
        }

        public Builder(ObjectReference defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.fieldPath = defaults.fieldPath;
            this.kind = defaults.kind;
            this.name = defaults.name;
            this.namespace = defaults.namespace;
            this.resourceVersion = defaults.resourceVersion;
            this.uid = defaults.uid;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder fieldPath(@Nullable String fieldPath) {
            this.fieldPath = fieldPath;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder namespace(@Nullable String namespace) {
            this.namespace = namespace;
            return this;
        }

        @CustomType.Setter
        public Builder resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        @CustomType.Setter
        public Builder uid(@Nullable String uid) {
            this.uid = uid;
            return this;
        }

        public ObjectReference build() {
            ObjectReference _resultValue = new ObjectReference();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.fieldPath = this.fieldPath;
            _resultValue.kind = this.kind;
            _resultValue.name = this.name;
            _resultValue.namespace = this.namespace;
            _resultValue.resourceVersion = this.resourceVersion;
            _resultValue.uid = this.uid;
            return _resultValue;
        }
    }
}

