/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.TypedLocalObjectReference;
import com.pulumi.kubernetes.core.v1.outputs.TypedObjectReference;
import com.pulumi.kubernetes.core.v1.outputs.VolumeResourceRequirements;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PersistentVolumeClaimSpec {
    @Nullable
    private List<String> accessModes;
    @Nullable
    private TypedLocalObjectReference dataSource;
    @Nullable
    private TypedObjectReference dataSourceRef;
    @Nullable
    private VolumeResourceRequirements resources;
    @Nullable
    private LabelSelector selector;
    @Nullable
    private String storageClassName;
    @Nullable
    private String volumeAttributesClassName;
    @Nullable
    private String volumeMode;
    @Nullable
    private String volumeName;

    private PersistentVolumeClaimSpec() {
    }

    public List<String> accessModes() {
        return this.accessModes == null ? List.of() : this.accessModes;
    }

    public Optional<TypedLocalObjectReference> dataSource() {
        return Optional.ofNullable(this.dataSource);
    }

    public Optional<TypedObjectReference> dataSourceRef() {
        return Optional.ofNullable(this.dataSourceRef);
    }

    public Optional<VolumeResourceRequirements> resources() {
        return Optional.ofNullable(this.resources);
    }

    public Optional<LabelSelector> selector() {
        return Optional.ofNullable(this.selector);
    }

    public Optional<String> storageClassName() {
        return Optional.ofNullable(this.storageClassName);
    }

    public Optional<String> volumeAttributesClassName() {
        return Optional.ofNullable(this.volumeAttributesClassName);
    }

    public Optional<String> volumeMode() {
        return Optional.ofNullable(this.volumeMode);
    }

    public Optional<String> volumeName() {
        return Optional.ofNullable(this.volumeName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PersistentVolumeClaimSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<String> accessModes;
        @Nullable
        private TypedLocalObjectReference dataSource;
        @Nullable
        private TypedObjectReference dataSourceRef;
        @Nullable
        private VolumeResourceRequirements resources;
        @Nullable
        private LabelSelector selector;
        @Nullable
        private String storageClassName;
        @Nullable
        private String volumeAttributesClassName;
        @Nullable
        private String volumeMode;
        @Nullable
        private String volumeName;

        public Builder() {
        }

        public Builder(PersistentVolumeClaimSpec defaults) {
            Objects.requireNonNull(defaults);
            this.accessModes = defaults.accessModes;
            this.dataSource = defaults.dataSource;
            this.dataSourceRef = defaults.dataSourceRef;
            this.resources = defaults.resources;
            this.selector = defaults.selector;
            this.storageClassName = defaults.storageClassName;
            this.volumeAttributesClassName = defaults.volumeAttributesClassName;
            this.volumeMode = defaults.volumeMode;
            this.volumeName = defaults.volumeName;
        }

        @CustomType.Setter
        public Builder accessModes(@Nullable List<String> accessModes) {
            this.accessModes = accessModes;
            return this;
        }

        public Builder accessModes(String ... accessModes) {
            return this.accessModes(List.of(accessModes));
        }

        @CustomType.Setter
        public Builder dataSource(@Nullable TypedLocalObjectReference dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @CustomType.Setter
        public Builder dataSourceRef(@Nullable TypedObjectReference dataSourceRef) {
            this.dataSourceRef = dataSourceRef;
            return this;
        }

        @CustomType.Setter
        public Builder resources(@Nullable VolumeResourceRequirements resources) {
            this.resources = resources;
            return this;
        }

        @CustomType.Setter
        public Builder selector(@Nullable LabelSelector selector) {
            this.selector = selector;
            return this;
        }

        @CustomType.Setter
        public Builder storageClassName(@Nullable String storageClassName) {
            this.storageClassName = storageClassName;
            return this;
        }

        @CustomType.Setter
        public Builder volumeAttributesClassName(@Nullable String volumeAttributesClassName) {
            this.volumeAttributesClassName = volumeAttributesClassName;
            return this;
        }

        @CustomType.Setter
        public Builder volumeMode(@Nullable String volumeMode) {
            this.volumeMode = volumeMode;
            return this;
        }

        @CustomType.Setter
        public Builder volumeName(@Nullable String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public PersistentVolumeClaimSpec build() {
            PersistentVolumeClaimSpec _resultValue = new PersistentVolumeClaimSpec();
            _resultValue.accessModes = this.accessModes;
            _resultValue.dataSource = this.dataSource;
            _resultValue.dataSourceRef = this.dataSourceRef;
            _resultValue.resources = this.resources;
            _resultValue.selector = this.selector;
            _resultValue.storageClassName = this.storageClassName;
            _resultValue.volumeAttributesClassName = this.volumeAttributesClassName;
            _resultValue.volumeMode = this.volumeMode;
            _resultValue.volumeName = this.volumeName;
            return _resultValue;
        }
    }
}

