/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.PodSpec;
import com.pulumi.kubernetes.core.v1.outputs.PodStatus;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class Pod {
    @Nullable
    private String apiVersion;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private PodSpec spec;
    @Nullable
    private PodStatus status;

    private Pod() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public Optional<PodSpec> spec() {
        return Optional.ofNullable(this.spec);
    }

    public Optional<PodStatus> status() {
        return Optional.ofNullable(this.status);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Pod defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private PodSpec spec;
        @Nullable
        private PodStatus status;

        public Builder() {
        }

        public Builder(Pod defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.spec = defaults.spec;
            this.status = defaults.status;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder spec(@Nullable PodSpec spec) {
            this.spec = spec;
            return this;
        }

        @CustomType.Setter
        public Builder status(@Nullable PodStatus status) {
            this.status = status;
            return this;
        }

        public Pod build() {
            Pod _resultValue = new Pod();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.spec = this.spec;
            _resultValue.status = this.status;
            return _resultValue;
        }
    }
}

