/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PodAffinityTerm {
    @Nullable
    private LabelSelector labelSelector;
    @Nullable
    private List<String> matchLabelKeys;
    @Nullable
    private List<String> mismatchLabelKeys;
    @Nullable
    private LabelSelector namespaceSelector;
    @Nullable
    private List<String> namespaces;
    private String topologyKey;

    private PodAffinityTerm() {
    }

    public Optional<LabelSelector> labelSelector() {
        return Optional.ofNullable(this.labelSelector);
    }

    public List<String> matchLabelKeys() {
        return this.matchLabelKeys == null ? List.of() : this.matchLabelKeys;
    }

    public List<String> mismatchLabelKeys() {
        return this.mismatchLabelKeys == null ? List.of() : this.mismatchLabelKeys;
    }

    public Optional<LabelSelector> namespaceSelector() {
        return Optional.ofNullable(this.namespaceSelector);
    }

    public List<String> namespaces() {
        return this.namespaces == null ? List.of() : this.namespaces;
    }

    public String topologyKey() {
        return this.topologyKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PodAffinityTerm defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private LabelSelector labelSelector;
        @Nullable
        private List<String> matchLabelKeys;
        @Nullable
        private List<String> mismatchLabelKeys;
        @Nullable
        private LabelSelector namespaceSelector;
        @Nullable
        private List<String> namespaces;
        private String topologyKey;

        public Builder() {
        }

        public Builder(PodAffinityTerm defaults) {
            Objects.requireNonNull(defaults);
            this.labelSelector = defaults.labelSelector;
            this.matchLabelKeys = defaults.matchLabelKeys;
            this.mismatchLabelKeys = defaults.mismatchLabelKeys;
            this.namespaceSelector = defaults.namespaceSelector;
            this.namespaces = defaults.namespaces;
            this.topologyKey = defaults.topologyKey;
        }

        @CustomType.Setter
        public Builder labelSelector(@Nullable LabelSelector labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        @CustomType.Setter
        public Builder matchLabelKeys(@Nullable List<String> matchLabelKeys) {
            this.matchLabelKeys = matchLabelKeys;
            return this;
        }

        public Builder matchLabelKeys(String ... matchLabelKeys) {
            return this.matchLabelKeys(List.of(matchLabelKeys));
        }

        @CustomType.Setter
        public Builder mismatchLabelKeys(@Nullable List<String> mismatchLabelKeys) {
            this.mismatchLabelKeys = mismatchLabelKeys;
            return this;
        }

        public Builder mismatchLabelKeys(String ... mismatchLabelKeys) {
            return this.mismatchLabelKeys(List.of(mismatchLabelKeys));
        }

        @CustomType.Setter
        public Builder namespaceSelector(@Nullable LabelSelector namespaceSelector) {
            this.namespaceSelector = namespaceSelector;
            return this;
        }

        @CustomType.Setter
        public Builder namespaces(@Nullable List<String> namespaces) {
            this.namespaces = namespaces;
            return this;
        }

        public Builder namespaces(String ... namespaces) {
            return this.namespaces(List.of(namespaces));
        }

        @CustomType.Setter
        public Builder topologyKey(String topologyKey) {
            if (topologyKey == null) {
                throw new MissingRequiredPropertyException("PodAffinityTerm", "topologyKey");
            }
            this.topologyKey = topologyKey;
            return this;
        }

        public PodAffinityTerm build() {
            PodAffinityTerm _resultValue = new PodAffinityTerm();
            _resultValue.labelSelector = this.labelSelector;
            _resultValue.matchLabelKeys = this.matchLabelKeys;
            _resultValue.mismatchLabelKeys = this.mismatchLabelKeys;
            _resultValue.namespaceSelector = this.namespaceSelector;
            _resultValue.namespaces = this.namespaces;
            _resultValue.topologyKey = this.topologyKey;
            return _resultValue;
        }
    }
}

