/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PodCondition {
    @Nullable
    private String lastProbeTime;
    @Nullable
    private String lastTransitionTime;
    @Nullable
    private String message;
    @Nullable
    private String reason;
    private String status;
    private String type;

    private PodCondition() {
    }

    public Optional<String> lastProbeTime() {
        return Optional.ofNullable(this.lastProbeTime);
    }

    public Optional<String> lastTransitionTime() {
        return Optional.ofNullable(this.lastTransitionTime);
    }

    public Optional<String> message() {
        return Optional.ofNullable(this.message);
    }

    public Optional<String> reason() {
        return Optional.ofNullable(this.reason);
    }

    public String status() {
        return this.status;
    }

    public String type() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PodCondition defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String lastProbeTime;
        @Nullable
        private String lastTransitionTime;
        @Nullable
        private String message;
        @Nullable
        private String reason;
        private String status;
        private String type;

        public Builder() {
        }

        public Builder(PodCondition defaults) {
            Objects.requireNonNull(defaults);
            this.lastProbeTime = defaults.lastProbeTime;
            this.lastTransitionTime = defaults.lastTransitionTime;
            this.message = defaults.message;
            this.reason = defaults.reason;
            this.status = defaults.status;
            this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder lastProbeTime(@Nullable String lastProbeTime) {
            this.lastProbeTime = lastProbeTime;
            return this;
        }

        @CustomType.Setter
        public Builder lastTransitionTime(@Nullable String lastTransitionTime) {
            this.lastTransitionTime = lastTransitionTime;
            return this;
        }

        @CustomType.Setter
        public Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        @CustomType.Setter
        public Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CustomType.Setter
        public Builder status(String status) {
            if (status == null) {
                throw new MissingRequiredPropertyException("PodCondition", "status");
            }
            this.status = status;
            return this;
        }

        @CustomType.Setter
        public Builder type(String type) {
            if (type == null) {
                throw new MissingRequiredPropertyException("PodCondition", "type");
            }
            this.type = type;
            return this;
        }

        public PodCondition build() {
            PodCondition _resultValue = new PodCondition();
            _resultValue.lastProbeTime = this.lastProbeTime;
            _resultValue.lastTransitionTime = this.lastTransitionTime;
            _resultValue.message = this.message;
            _resultValue.reason = this.reason;
            _resultValue.status = this.status;
            _resultValue.type = this.type;
            return _resultValue;
        }
    }
}

