/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.ClaimSource;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PodResourceClaim {
    private String name;
    @Nullable
    private String resourceClaimName;
    @Nullable
    private String resourceClaimTemplateName;
    @Nullable
    private ClaimSource source;

    private PodResourceClaim() {
    }

    public String name() {
        return this.name;
    }

    public Optional<String> resourceClaimName() {
        return Optional.ofNullable(this.resourceClaimName);
    }

    public Optional<String> resourceClaimTemplateName() {
        return Optional.ofNullable(this.resourceClaimTemplateName);
    }

    public Optional<ClaimSource> source() {
        return Optional.ofNullable(this.source);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PodResourceClaim defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String name;
        @Nullable
        private String resourceClaimName;
        @Nullable
        private String resourceClaimTemplateName;
        @Nullable
        private ClaimSource source;

        public Builder() {
        }

        public Builder(PodResourceClaim defaults) {
            Objects.requireNonNull(defaults);
            this.name = defaults.name;
            this.resourceClaimName = defaults.resourceClaimName;
            this.resourceClaimTemplateName = defaults.resourceClaimTemplateName;
            this.source = defaults.source;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("PodResourceClaim", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder resourceClaimName(@Nullable String resourceClaimName) {
            this.resourceClaimName = resourceClaimName;
            return this;
        }

        @CustomType.Setter
        public Builder resourceClaimTemplateName(@Nullable String resourceClaimTemplateName) {
            this.resourceClaimTemplateName = resourceClaimTemplateName;
            return this;
        }

        @CustomType.Setter
        public Builder source(@Nullable ClaimSource source) {
            this.source = source;
            return this;
        }

        public PodResourceClaim build() {
            PodResourceClaim _resultValue = new PodResourceClaim();
            _resultValue.name = this.name;
            _resultValue.resourceClaimName = this.resourceClaimName;
            _resultValue.resourceClaimTemplateName = this.resourceClaimTemplateName;
            _resultValue.source = this.source;
            return _resultValue;
        }
    }
}

