/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.AppArmorProfile;
import com.pulumi.kubernetes.core.v1.outputs.SELinuxOptions;
import com.pulumi.kubernetes.core.v1.outputs.SeccompProfile;
import com.pulumi.kubernetes.core.v1.outputs.Sysctl;
import com.pulumi.kubernetes.core.v1.outputs.WindowsSecurityContextOptions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PodSecurityContext {
    @Nullable
    private AppArmorProfile appArmorProfile;
    @Nullable
    private Integer fsGroup;
    @Nullable
    private String fsGroupChangePolicy;
    @Nullable
    private Integer runAsGroup;
    @Nullable
    private Boolean runAsNonRoot;
    @Nullable
    private Integer runAsUser;
    @Nullable
    private SELinuxOptions seLinuxOptions;
    @Nullable
    private SeccompProfile seccompProfile;
    @Nullable
    private List<Integer> supplementalGroups;
    @Nullable
    private String supplementalGroupsPolicy;
    @Nullable
    private List<Sysctl> sysctls;
    @Nullable
    private WindowsSecurityContextOptions windowsOptions;

    private PodSecurityContext() {
    }

    public Optional<AppArmorProfile> appArmorProfile() {
        return Optional.ofNullable(this.appArmorProfile);
    }

    public Optional<Integer> fsGroup() {
        return Optional.ofNullable(this.fsGroup);
    }

    public Optional<String> fsGroupChangePolicy() {
        return Optional.ofNullable(this.fsGroupChangePolicy);
    }

    public Optional<Integer> runAsGroup() {
        return Optional.ofNullable(this.runAsGroup);
    }

    public Optional<Boolean> runAsNonRoot() {
        return Optional.ofNullable(this.runAsNonRoot);
    }

    public Optional<Integer> runAsUser() {
        return Optional.ofNullable(this.runAsUser);
    }

    public Optional<SELinuxOptions> seLinuxOptions() {
        return Optional.ofNullable(this.seLinuxOptions);
    }

    public Optional<SeccompProfile> seccompProfile() {
        return Optional.ofNullable(this.seccompProfile);
    }

    public List<Integer> supplementalGroups() {
        return this.supplementalGroups == null ? List.of() : this.supplementalGroups;
    }

    public Optional<String> supplementalGroupsPolicy() {
        return Optional.ofNullable(this.supplementalGroupsPolicy);
    }

    public List<Sysctl> sysctls() {
        return this.sysctls == null ? List.of() : this.sysctls;
    }

    public Optional<WindowsSecurityContextOptions> windowsOptions() {
        return Optional.ofNullable(this.windowsOptions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PodSecurityContext defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private AppArmorProfile appArmorProfile;
        @Nullable
        private Integer fsGroup;
        @Nullable
        private String fsGroupChangePolicy;
        @Nullable
        private Integer runAsGroup;
        @Nullable
        private Boolean runAsNonRoot;
        @Nullable
        private Integer runAsUser;
        @Nullable
        private SELinuxOptions seLinuxOptions;
        @Nullable
        private SeccompProfile seccompProfile;
        @Nullable
        private List<Integer> supplementalGroups;
        @Nullable
        private String supplementalGroupsPolicy;
        @Nullable
        private List<Sysctl> sysctls;
        @Nullable
        private WindowsSecurityContextOptions windowsOptions;

        public Builder() {
        }

        public Builder(PodSecurityContext defaults) {
            Objects.requireNonNull(defaults);
            this.appArmorProfile = defaults.appArmorProfile;
            this.fsGroup = defaults.fsGroup;
            this.fsGroupChangePolicy = defaults.fsGroupChangePolicy;
            this.runAsGroup = defaults.runAsGroup;
            this.runAsNonRoot = defaults.runAsNonRoot;
            this.runAsUser = defaults.runAsUser;
            this.seLinuxOptions = defaults.seLinuxOptions;
            this.seccompProfile = defaults.seccompProfile;
            this.supplementalGroups = defaults.supplementalGroups;
            this.supplementalGroupsPolicy = defaults.supplementalGroupsPolicy;
            this.sysctls = defaults.sysctls;
            this.windowsOptions = defaults.windowsOptions;
        }

        @CustomType.Setter
        public Builder appArmorProfile(@Nullable AppArmorProfile appArmorProfile) {
            this.appArmorProfile = appArmorProfile;
            return this;
        }

        @CustomType.Setter
        public Builder fsGroup(@Nullable Integer fsGroup) {
            this.fsGroup = fsGroup;
            return this;
        }

        @CustomType.Setter
        public Builder fsGroupChangePolicy(@Nullable String fsGroupChangePolicy) {
            this.fsGroupChangePolicy = fsGroupChangePolicy;
            return this;
        }

        @CustomType.Setter
        public Builder runAsGroup(@Nullable Integer runAsGroup) {
            this.runAsGroup = runAsGroup;
            return this;
        }

        @CustomType.Setter
        public Builder runAsNonRoot(@Nullable Boolean runAsNonRoot) {
            this.runAsNonRoot = runAsNonRoot;
            return this;
        }

        @CustomType.Setter
        public Builder runAsUser(@Nullable Integer runAsUser) {
            this.runAsUser = runAsUser;
            return this;
        }

        @CustomType.Setter
        public Builder seLinuxOptions(@Nullable SELinuxOptions seLinuxOptions) {
            this.seLinuxOptions = seLinuxOptions;
            return this;
        }

        @CustomType.Setter
        public Builder seccompProfile(@Nullable SeccompProfile seccompProfile) {
            this.seccompProfile = seccompProfile;
            return this;
        }

        @CustomType.Setter
        public Builder supplementalGroups(@Nullable List<Integer> supplementalGroups) {
            this.supplementalGroups = supplementalGroups;
            return this;
        }

        public Builder supplementalGroups(Integer ... supplementalGroups) {
            return this.supplementalGroups(List.of(supplementalGroups));
        }

        @CustomType.Setter
        public Builder supplementalGroupsPolicy(@Nullable String supplementalGroupsPolicy) {
            this.supplementalGroupsPolicy = supplementalGroupsPolicy;
            return this;
        }

        @CustomType.Setter
        public Builder sysctls(@Nullable List<Sysctl> sysctls) {
            this.sysctls = sysctls;
            return this;
        }

        public Builder sysctls(Sysctl ... sysctls) {
            return this.sysctls(List.of(sysctls));
        }

        @CustomType.Setter
        public Builder windowsOptions(@Nullable WindowsSecurityContextOptions windowsOptions) {
            this.windowsOptions = windowsOptions;
            return this;
        }

        public PodSecurityContext build() {
            PodSecurityContext _resultValue = new PodSecurityContext();
            _resultValue.appArmorProfile = this.appArmorProfile;
            _resultValue.fsGroup = this.fsGroup;
            _resultValue.fsGroupChangePolicy = this.fsGroupChangePolicy;
            _resultValue.runAsGroup = this.runAsGroup;
            _resultValue.runAsNonRoot = this.runAsNonRoot;
            _resultValue.runAsUser = this.runAsUser;
            _resultValue.seLinuxOptions = this.seLinuxOptions;
            _resultValue.seccompProfile = this.seccompProfile;
            _resultValue.supplementalGroups = this.supplementalGroups;
            _resultValue.supplementalGroupsPolicy = this.supplementalGroupsPolicy;
            _resultValue.sysctls = this.sysctls;
            _resultValue.windowsOptions = this.windowsOptions;
            return _resultValue;
        }
    }
}

