/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.Affinity;
import com.pulumi.kubernetes.core.v1.outputs.Container;
import com.pulumi.kubernetes.core.v1.outputs.EphemeralContainer;
import com.pulumi.kubernetes.core.v1.outputs.HostAlias;
import com.pulumi.kubernetes.core.v1.outputs.LocalObjectReference;
import com.pulumi.kubernetes.core.v1.outputs.PodDNSConfig;
import com.pulumi.kubernetes.core.v1.outputs.PodOS;
import com.pulumi.kubernetes.core.v1.outputs.PodReadinessGate;
import com.pulumi.kubernetes.core.v1.outputs.PodResourceClaim;
import com.pulumi.kubernetes.core.v1.outputs.PodSchedulingGate;
import com.pulumi.kubernetes.core.v1.outputs.PodSecurityContext;
import com.pulumi.kubernetes.core.v1.outputs.Toleration;
import com.pulumi.kubernetes.core.v1.outputs.TopologySpreadConstraint;
import com.pulumi.kubernetes.core.v1.outputs.Volume;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PodSpec {
    @Nullable
    private Integer activeDeadlineSeconds;
    @Nullable
    private Affinity affinity;
    @Nullable
    private Boolean automountServiceAccountToken;
    private List<Container> containers;
    @Nullable
    private PodDNSConfig dnsConfig;
    @Nullable
    private String dnsPolicy;
    @Nullable
    private Boolean enableServiceLinks;
    @Nullable
    private List<EphemeralContainer> ephemeralContainers;
    @Nullable
    private List<HostAlias> hostAliases;
    @Nullable
    private Boolean hostIPC;
    @Nullable
    private Boolean hostNetwork;
    @Nullable
    private Boolean hostPID;
    @Nullable
    private Boolean hostUsers;
    @Nullable
    private String hostname;
    @Nullable
    private List<LocalObjectReference> imagePullSecrets;
    @Nullable
    private List<Container> initContainers;
    @Nullable
    private String nodeName;
    @Nullable
    private Map<String, String> nodeSelector;
    @Nullable
    private PodOS os;
    @Nullable
    private Map<String, String> overhead;
    @Nullable
    private String preemptionPolicy;
    @Nullable
    private Integer priority;
    @Nullable
    private String priorityClassName;
    @Nullable
    private List<PodReadinessGate> readinessGates;
    @Nullable
    private List<PodResourceClaim> resourceClaims;
    @Nullable
    private String restartPolicy;
    @Nullable
    private String runtimeClassName;
    @Nullable
    private String schedulerName;
    @Nullable
    private List<PodSchedulingGate> schedulingGates;
    @Nullable
    private PodSecurityContext securityContext;
    @Nullable
    private String serviceAccount;
    @Nullable
    private String serviceAccountName;
    @Nullable
    private Boolean setHostnameAsFQDN;
    @Nullable
    private Boolean shareProcessNamespace;
    @Nullable
    private String subdomain;
    @Nullable
    private Integer terminationGracePeriodSeconds;
    @Nullable
    private List<Toleration> tolerations;
    @Nullable
    private List<TopologySpreadConstraint> topologySpreadConstraints;
    @Nullable
    private List<Volume> volumes;

    private PodSpec() {
    }

    public Optional<Integer> activeDeadlineSeconds() {
        return Optional.ofNullable(this.activeDeadlineSeconds);
    }

    public Optional<Affinity> affinity() {
        return Optional.ofNullable(this.affinity);
    }

    public Optional<Boolean> automountServiceAccountToken() {
        return Optional.ofNullable(this.automountServiceAccountToken);
    }

    public List<Container> containers() {
        return this.containers;
    }

    public Optional<PodDNSConfig> dnsConfig() {
        return Optional.ofNullable(this.dnsConfig);
    }

    public Optional<String> dnsPolicy() {
        return Optional.ofNullable(this.dnsPolicy);
    }

    public Optional<Boolean> enableServiceLinks() {
        return Optional.ofNullable(this.enableServiceLinks);
    }

    public List<EphemeralContainer> ephemeralContainers() {
        return this.ephemeralContainers == null ? List.of() : this.ephemeralContainers;
    }

    public List<HostAlias> hostAliases() {
        return this.hostAliases == null ? List.of() : this.hostAliases;
    }

    public Optional<Boolean> hostIPC() {
        return Optional.ofNullable(this.hostIPC);
    }

    public Optional<Boolean> hostNetwork() {
        return Optional.ofNullable(this.hostNetwork);
    }

    public Optional<Boolean> hostPID() {
        return Optional.ofNullable(this.hostPID);
    }

    public Optional<Boolean> hostUsers() {
        return Optional.ofNullable(this.hostUsers);
    }

    public Optional<String> hostname() {
        return Optional.ofNullable(this.hostname);
    }

    public List<LocalObjectReference> imagePullSecrets() {
        return this.imagePullSecrets == null ? List.of() : this.imagePullSecrets;
    }

    public List<Container> initContainers() {
        return this.initContainers == null ? List.of() : this.initContainers;
    }

    public Optional<String> nodeName() {
        return Optional.ofNullable(this.nodeName);
    }

    public Map<String, String> nodeSelector() {
        return this.nodeSelector == null ? Map.of() : this.nodeSelector;
    }

    public Optional<PodOS> os() {
        return Optional.ofNullable(this.os);
    }

    public Map<String, String> overhead() {
        return this.overhead == null ? Map.of() : this.overhead;
    }

    public Optional<String> preemptionPolicy() {
        return Optional.ofNullable(this.preemptionPolicy);
    }

    public Optional<Integer> priority() {
        return Optional.ofNullable(this.priority);
    }

    public Optional<String> priorityClassName() {
        return Optional.ofNullable(this.priorityClassName);
    }

    public List<PodReadinessGate> readinessGates() {
        return this.readinessGates == null ? List.of() : this.readinessGates;
    }

    public List<PodResourceClaim> resourceClaims() {
        return this.resourceClaims == null ? List.of() : this.resourceClaims;
    }

    public Optional<String> restartPolicy() {
        return Optional.ofNullable(this.restartPolicy);
    }

    public Optional<String> runtimeClassName() {
        return Optional.ofNullable(this.runtimeClassName);
    }

    public Optional<String> schedulerName() {
        return Optional.ofNullable(this.schedulerName);
    }

    public List<PodSchedulingGate> schedulingGates() {
        return this.schedulingGates == null ? List.of() : this.schedulingGates;
    }

    public Optional<PodSecurityContext> securityContext() {
        return Optional.ofNullable(this.securityContext);
    }

    public Optional<String> serviceAccount() {
        return Optional.ofNullable(this.serviceAccount);
    }

    public Optional<String> serviceAccountName() {
        return Optional.ofNullable(this.serviceAccountName);
    }

    public Optional<Boolean> setHostnameAsFQDN() {
        return Optional.ofNullable(this.setHostnameAsFQDN);
    }

    public Optional<Boolean> shareProcessNamespace() {
        return Optional.ofNullable(this.shareProcessNamespace);
    }

    public Optional<String> subdomain() {
        return Optional.ofNullable(this.subdomain);
    }

    public Optional<Integer> terminationGracePeriodSeconds() {
        return Optional.ofNullable(this.terminationGracePeriodSeconds);
    }

    public List<Toleration> tolerations() {
        return this.tolerations == null ? List.of() : this.tolerations;
    }

    public List<TopologySpreadConstraint> topologySpreadConstraints() {
        return this.topologySpreadConstraints == null ? List.of() : this.topologySpreadConstraints;
    }

    public List<Volume> volumes() {
        return this.volumes == null ? List.of() : this.volumes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PodSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer activeDeadlineSeconds;
        @Nullable
        private Affinity affinity;
        @Nullable
        private Boolean automountServiceAccountToken;
        private List<Container> containers;
        @Nullable
        private PodDNSConfig dnsConfig;
        @Nullable
        private String dnsPolicy;
        @Nullable
        private Boolean enableServiceLinks;
        @Nullable
        private List<EphemeralContainer> ephemeralContainers;
        @Nullable
        private List<HostAlias> hostAliases;
        @Nullable
        private Boolean hostIPC;
        @Nullable
        private Boolean hostNetwork;
        @Nullable
        private Boolean hostPID;
        @Nullable
        private Boolean hostUsers;
        @Nullable
        private String hostname;
        @Nullable
        private List<LocalObjectReference> imagePullSecrets;
        @Nullable
        private List<Container> initContainers;
        @Nullable
        private String nodeName;
        @Nullable
        private Map<String, String> nodeSelector;
        @Nullable
        private PodOS os;
        @Nullable
        private Map<String, String> overhead;
        @Nullable
        private String preemptionPolicy;
        @Nullable
        private Integer priority;
        @Nullable
        private String priorityClassName;
        @Nullable
        private List<PodReadinessGate> readinessGates;
        @Nullable
        private List<PodResourceClaim> resourceClaims;
        @Nullable
        private String restartPolicy;
        @Nullable
        private String runtimeClassName;
        @Nullable
        private String schedulerName;
        @Nullable
        private List<PodSchedulingGate> schedulingGates;
        @Nullable
        private PodSecurityContext securityContext;
        @Nullable
        private String serviceAccount;
        @Nullable
        private String serviceAccountName;
        @Nullable
        private Boolean setHostnameAsFQDN;
        @Nullable
        private Boolean shareProcessNamespace;
        @Nullable
        private String subdomain;
        @Nullable
        private Integer terminationGracePeriodSeconds;
        @Nullable
        private List<Toleration> tolerations;
        @Nullable
        private List<TopologySpreadConstraint> topologySpreadConstraints;
        @Nullable
        private List<Volume> volumes;

        public Builder() {
        }

        public Builder(PodSpec defaults) {
            Objects.requireNonNull(defaults);
            this.activeDeadlineSeconds = defaults.activeDeadlineSeconds;
            this.affinity = defaults.affinity;
            this.automountServiceAccountToken = defaults.automountServiceAccountToken;
            this.containers = defaults.containers;
            this.dnsConfig = defaults.dnsConfig;
            this.dnsPolicy = defaults.dnsPolicy;
            this.enableServiceLinks = defaults.enableServiceLinks;
            this.ephemeralContainers = defaults.ephemeralContainers;
            this.hostAliases = defaults.hostAliases;
            this.hostIPC = defaults.hostIPC;
            this.hostNetwork = defaults.hostNetwork;
            this.hostPID = defaults.hostPID;
            this.hostUsers = defaults.hostUsers;
            this.hostname = defaults.hostname;
            this.imagePullSecrets = defaults.imagePullSecrets;
            this.initContainers = defaults.initContainers;
            this.nodeName = defaults.nodeName;
            this.nodeSelector = defaults.nodeSelector;
            this.os = defaults.os;
            this.overhead = defaults.overhead;
            this.preemptionPolicy = defaults.preemptionPolicy;
            this.priority = defaults.priority;
            this.priorityClassName = defaults.priorityClassName;
            this.readinessGates = defaults.readinessGates;
            this.resourceClaims = defaults.resourceClaims;
            this.restartPolicy = defaults.restartPolicy;
            this.runtimeClassName = defaults.runtimeClassName;
            this.schedulerName = defaults.schedulerName;
            this.schedulingGates = defaults.schedulingGates;
            this.securityContext = defaults.securityContext;
            this.serviceAccount = defaults.serviceAccount;
            this.serviceAccountName = defaults.serviceAccountName;
            this.setHostnameAsFQDN = defaults.setHostnameAsFQDN;
            this.shareProcessNamespace = defaults.shareProcessNamespace;
            this.subdomain = defaults.subdomain;
            this.terminationGracePeriodSeconds = defaults.terminationGracePeriodSeconds;
            this.tolerations = defaults.tolerations;
            this.topologySpreadConstraints = defaults.topologySpreadConstraints;
            this.volumes = defaults.volumes;
        }

        @CustomType.Setter
        public Builder activeDeadlineSeconds(@Nullable Integer activeDeadlineSeconds) {
            this.activeDeadlineSeconds = activeDeadlineSeconds;
            return this;
        }

        @CustomType.Setter
        public Builder affinity(@Nullable Affinity affinity) {
            this.affinity = affinity;
            return this;
        }

        @CustomType.Setter
        public Builder automountServiceAccountToken(@Nullable Boolean automountServiceAccountToken) {
            this.automountServiceAccountToken = automountServiceAccountToken;
            return this;
        }

        @CustomType.Setter
        public Builder containers(List<Container> containers) {
            if (containers == null) {
                throw new MissingRequiredPropertyException("PodSpec", "containers");
            }
            this.containers = containers;
            return this;
        }

        public Builder containers(Container ... containers) {
            return this.containers(List.of(containers));
        }

        @CustomType.Setter
        public Builder dnsConfig(@Nullable PodDNSConfig dnsConfig) {
            this.dnsConfig = dnsConfig;
            return this;
        }

        @CustomType.Setter
        public Builder dnsPolicy(@Nullable String dnsPolicy) {
            this.dnsPolicy = dnsPolicy;
            return this;
        }

        @CustomType.Setter
        public Builder enableServiceLinks(@Nullable Boolean enableServiceLinks) {
            this.enableServiceLinks = enableServiceLinks;
            return this;
        }

        @CustomType.Setter
        public Builder ephemeralContainers(@Nullable List<EphemeralContainer> ephemeralContainers) {
            this.ephemeralContainers = ephemeralContainers;
            return this;
        }

        public Builder ephemeralContainers(EphemeralContainer ... ephemeralContainers) {
            return this.ephemeralContainers(List.of(ephemeralContainers));
        }

        @CustomType.Setter
        public Builder hostAliases(@Nullable List<HostAlias> hostAliases) {
            this.hostAliases = hostAliases;
            return this;
        }

        public Builder hostAliases(HostAlias ... hostAliases) {
            return this.hostAliases(List.of(hostAliases));
        }

        @CustomType.Setter
        public Builder hostIPC(@Nullable Boolean hostIPC) {
            this.hostIPC = hostIPC;
            return this;
        }

        @CustomType.Setter
        public Builder hostNetwork(@Nullable Boolean hostNetwork) {
            this.hostNetwork = hostNetwork;
            return this;
        }

        @CustomType.Setter
        public Builder hostPID(@Nullable Boolean hostPID) {
            this.hostPID = hostPID;
            return this;
        }

        @CustomType.Setter
        public Builder hostUsers(@Nullable Boolean hostUsers) {
            this.hostUsers = hostUsers;
            return this;
        }

        @CustomType.Setter
        public Builder hostname(@Nullable String hostname) {
            this.hostname = hostname;
            return this;
        }

        @CustomType.Setter
        public Builder imagePullSecrets(@Nullable List<LocalObjectReference> imagePullSecrets) {
            this.imagePullSecrets = imagePullSecrets;
            return this;
        }

        public Builder imagePullSecrets(LocalObjectReference ... imagePullSecrets) {
            return this.imagePullSecrets(List.of(imagePullSecrets));
        }

        @CustomType.Setter
        public Builder initContainers(@Nullable List<Container> initContainers) {
            this.initContainers = initContainers;
            return this;
        }

        public Builder initContainers(Container ... initContainers) {
            return this.initContainers(List.of(initContainers));
        }

        @CustomType.Setter
        public Builder nodeName(@Nullable String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        @CustomType.Setter
        public Builder nodeSelector(@Nullable Map<String, String> nodeSelector) {
            this.nodeSelector = nodeSelector;
            return this;
        }

        @CustomType.Setter
        public Builder os(@Nullable PodOS os) {
            this.os = os;
            return this;
        }

        @CustomType.Setter
        public Builder overhead(@Nullable Map<String, String> overhead) {
            this.overhead = overhead;
            return this;
        }

        @CustomType.Setter
        public Builder preemptionPolicy(@Nullable String preemptionPolicy) {
            this.preemptionPolicy = preemptionPolicy;
            return this;
        }

        @CustomType.Setter
        public Builder priority(@Nullable Integer priority) {
            this.priority = priority;
            return this;
        }

        @CustomType.Setter
        public Builder priorityClassName(@Nullable String priorityClassName) {
            this.priorityClassName = priorityClassName;
            return this;
        }

        @CustomType.Setter
        public Builder readinessGates(@Nullable List<PodReadinessGate> readinessGates) {
            this.readinessGates = readinessGates;
            return this;
        }

        public Builder readinessGates(PodReadinessGate ... readinessGates) {
            return this.readinessGates(List.of(readinessGates));
        }

        @CustomType.Setter
        public Builder resourceClaims(@Nullable List<PodResourceClaim> resourceClaims) {
            this.resourceClaims = resourceClaims;
            return this;
        }

        public Builder resourceClaims(PodResourceClaim ... resourceClaims) {
            return this.resourceClaims(List.of(resourceClaims));
        }

        @CustomType.Setter
        public Builder restartPolicy(@Nullable String restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        @CustomType.Setter
        public Builder runtimeClassName(@Nullable String runtimeClassName) {
            this.runtimeClassName = runtimeClassName;
            return this;
        }

        @CustomType.Setter
        public Builder schedulerName(@Nullable String schedulerName) {
            this.schedulerName = schedulerName;
            return this;
        }

        @CustomType.Setter
        public Builder schedulingGates(@Nullable List<PodSchedulingGate> schedulingGates) {
            this.schedulingGates = schedulingGates;
            return this;
        }

        public Builder schedulingGates(PodSchedulingGate ... schedulingGates) {
            return this.schedulingGates(List.of(schedulingGates));
        }

        @CustomType.Setter
        public Builder securityContext(@Nullable PodSecurityContext securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        @CustomType.Setter
        public Builder serviceAccount(@Nullable String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        @CustomType.Setter
        public Builder serviceAccountName(@Nullable String serviceAccountName) {
            this.serviceAccountName = serviceAccountName;
            return this;
        }

        @CustomType.Setter
        public Builder setHostnameAsFQDN(@Nullable Boolean setHostnameAsFQDN) {
            this.setHostnameAsFQDN = setHostnameAsFQDN;
            return this;
        }

        @CustomType.Setter
        public Builder shareProcessNamespace(@Nullable Boolean shareProcessNamespace) {
            this.shareProcessNamespace = shareProcessNamespace;
            return this;
        }

        @CustomType.Setter
        public Builder subdomain(@Nullable String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        @CustomType.Setter
        public Builder terminationGracePeriodSeconds(@Nullable Integer terminationGracePeriodSeconds) {
            this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
            return this;
        }

        @CustomType.Setter
        public Builder tolerations(@Nullable List<Toleration> tolerations) {
            this.tolerations = tolerations;
            return this;
        }

        public Builder tolerations(Toleration ... tolerations) {
            return this.tolerations(List.of(tolerations));
        }

        @CustomType.Setter
        public Builder topologySpreadConstraints(@Nullable List<TopologySpreadConstraint> topologySpreadConstraints) {
            this.topologySpreadConstraints = topologySpreadConstraints;
            return this;
        }

        public Builder topologySpreadConstraints(TopologySpreadConstraint ... topologySpreadConstraints) {
            return this.topologySpreadConstraints(List.of(topologySpreadConstraints));
        }

        @CustomType.Setter
        public Builder volumes(@Nullable List<Volume> volumes) {
            this.volumes = volumes;
            return this;
        }

        public Builder volumes(Volume ... volumes) {
            return this.volumes(List.of(volumes));
        }

        public PodSpec build() {
            PodSpec _resultValue = new PodSpec();
            _resultValue.activeDeadlineSeconds = this.activeDeadlineSeconds;
            _resultValue.affinity = this.affinity;
            _resultValue.automountServiceAccountToken = this.automountServiceAccountToken;
            _resultValue.containers = this.containers;
            _resultValue.dnsConfig = this.dnsConfig;
            _resultValue.dnsPolicy = this.dnsPolicy;
            _resultValue.enableServiceLinks = this.enableServiceLinks;
            _resultValue.ephemeralContainers = this.ephemeralContainers;
            _resultValue.hostAliases = this.hostAliases;
            _resultValue.hostIPC = this.hostIPC;
            _resultValue.hostNetwork = this.hostNetwork;
            _resultValue.hostPID = this.hostPID;
            _resultValue.hostUsers = this.hostUsers;
            _resultValue.hostname = this.hostname;
            _resultValue.imagePullSecrets = this.imagePullSecrets;
            _resultValue.initContainers = this.initContainers;
            _resultValue.nodeName = this.nodeName;
            _resultValue.nodeSelector = this.nodeSelector;
            _resultValue.os = this.os;
            _resultValue.overhead = this.overhead;
            _resultValue.preemptionPolicy = this.preemptionPolicy;
            _resultValue.priority = this.priority;
            _resultValue.priorityClassName = this.priorityClassName;
            _resultValue.readinessGates = this.readinessGates;
            _resultValue.resourceClaims = this.resourceClaims;
            _resultValue.restartPolicy = this.restartPolicy;
            _resultValue.runtimeClassName = this.runtimeClassName;
            _resultValue.schedulerName = this.schedulerName;
            _resultValue.schedulingGates = this.schedulingGates;
            _resultValue.securityContext = this.securityContext;
            _resultValue.serviceAccount = this.serviceAccount;
            _resultValue.serviceAccountName = this.serviceAccountName;
            _resultValue.setHostnameAsFQDN = this.setHostnameAsFQDN;
            _resultValue.shareProcessNamespace = this.shareProcessNamespace;
            _resultValue.subdomain = this.subdomain;
            _resultValue.terminationGracePeriodSeconds = this.terminationGracePeriodSeconds;
            _resultValue.tolerations = this.tolerations;
            _resultValue.topologySpreadConstraints = this.topologySpreadConstraints;
            _resultValue.volumes = this.volumes;
            return _resultValue;
        }
    }
}

