/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PortStatus {
    @Nullable
    private String error;
    private Integer port;
    private String protocol;

    private PortStatus() {
    }

    public Optional<String> error() {
        return Optional.ofNullable(this.error);
    }

    public Integer port() {
        return this.port;
    }

    public String protocol() {
        return this.protocol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PortStatus defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String error;
        private Integer port;
        private String protocol;

        public Builder() {
        }

        public Builder(PortStatus defaults) {
            Objects.requireNonNull(defaults);
            this.error = defaults.error;
            this.port = defaults.port;
            this.protocol = defaults.protocol;
        }

        @CustomType.Setter
        public Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        @CustomType.Setter
        public Builder port(Integer port) {
            if (port == null) {
                throw new MissingRequiredPropertyException("PortStatus", "port");
            }
            this.port = port;
            return this;
        }

        @CustomType.Setter
        public Builder protocol(String protocol) {
            if (protocol == null) {
                throw new MissingRequiredPropertyException("PortStatus", "protocol");
            }
            this.protocol = protocol;
            return this;
        }

        public PortStatus build() {
            PortStatus _resultValue = new PortStatus();
            _resultValue.error = this.error;
            _resultValue.port = this.port;
            _resultValue.protocol = this.protocol;
            return _resultValue;
        }
    }
}

