/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.VolumeProjection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ProjectedVolumeSource {
    @Nullable
    private Integer defaultMode;
    private List<VolumeProjection> sources;

    private ProjectedVolumeSource() {
    }

    public Optional<Integer> defaultMode() {
        return Optional.ofNullable(this.defaultMode);
    }

    public List<VolumeProjection> sources() {
        return this.sources;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProjectedVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer defaultMode;
        private List<VolumeProjection> sources;

        public Builder() {
        }

        public Builder(ProjectedVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.defaultMode = defaults.defaultMode;
            this.sources = defaults.sources;
        }

        @CustomType.Setter
        public Builder defaultMode(@Nullable Integer defaultMode) {
            this.defaultMode = defaultMode;
            return this;
        }

        @CustomType.Setter
        public Builder sources(List<VolumeProjection> sources) {
            if (sources == null) {
                throw new MissingRequiredPropertyException("ProjectedVolumeSource", "sources");
            }
            this.sources = sources;
            return this;
        }

        public Builder sources(VolumeProjection ... sources) {
            return this.sources(List.of(sources));
        }

        public ProjectedVolumeSource build() {
            ProjectedVolumeSource _resultValue = new ProjectedVolumeSource();
            _resultValue.defaultMode = this.defaultMode;
            _resultValue.sources = this.sources;
            return _resultValue;
        }
    }
}

