/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class QuobyteVolumeSource {
    @Nullable
    private String group;
    @Nullable
    private Boolean readOnly;
    private String registry;
    @Nullable
    private String tenant;
    @Nullable
    private String user;
    private String volume;

    private QuobyteVolumeSource() {
    }

    public Optional<String> group() {
        return Optional.ofNullable(this.group);
    }

    public Optional<Boolean> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public String registry() {
        return this.registry;
    }

    public Optional<String> tenant() {
        return Optional.ofNullable(this.tenant);
    }

    public Optional<String> user() {
        return Optional.ofNullable(this.user);
    }

    public String volume() {
        return this.volume;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(QuobyteVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String group;
        @Nullable
        private Boolean readOnly;
        private String registry;
        @Nullable
        private String tenant;
        @Nullable
        private String user;
        private String volume;

        public Builder() {
        }

        public Builder(QuobyteVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.group = defaults.group;
            this.readOnly = defaults.readOnly;
            this.registry = defaults.registry;
            this.tenant = defaults.tenant;
            this.user = defaults.user;
            this.volume = defaults.volume;
        }

        @CustomType.Setter
        public Builder group(@Nullable String group) {
            this.group = group;
            return this;
        }

        @CustomType.Setter
        public Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @CustomType.Setter
        public Builder registry(String registry) {
            if (registry == null) {
                throw new MissingRequiredPropertyException("QuobyteVolumeSource", "registry");
            }
            this.registry = registry;
            return this;
        }

        @CustomType.Setter
        public Builder tenant(@Nullable String tenant) {
            this.tenant = tenant;
            return this;
        }

        @CustomType.Setter
        public Builder user(@Nullable String user) {
            this.user = user;
            return this;
        }

        @CustomType.Setter
        public Builder volume(String volume) {
            if (volume == null) {
                throw new MissingRequiredPropertyException("QuobyteVolumeSource", "volume");
            }
            this.volume = volume;
            return this;
        }

        public QuobyteVolumeSource build() {
            QuobyteVolumeSource _resultValue = new QuobyteVolumeSource();
            _resultValue.group = this.group;
            _resultValue.readOnly = this.readOnly;
            _resultValue.registry = this.registry;
            _resultValue.tenant = this.tenant;
            _resultValue.user = this.user;
            _resultValue.volume = this.volume;
            return _resultValue;
        }
    }
}

