/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.LocalObjectReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class RBDVolumeSource {
    @Nullable
    private String fsType;
    private String image;
    @Nullable
    private String keyring;
    private List<String> monitors;
    @Nullable
    private String pool;
    @Nullable
    private Boolean readOnly;
    @Nullable
    private LocalObjectReference secretRef;
    @Nullable
    private String user;

    private RBDVolumeSource() {
    }

    public Optional<String> fsType() {
        return Optional.ofNullable(this.fsType);
    }

    public String image() {
        return this.image;
    }

    public Optional<String> keyring() {
        return Optional.ofNullable(this.keyring);
    }

    public List<String> monitors() {
        return this.monitors;
    }

    public Optional<String> pool() {
        return Optional.ofNullable(this.pool);
    }

    public Optional<Boolean> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public Optional<LocalObjectReference> secretRef() {
        return Optional.ofNullable(this.secretRef);
    }

    public Optional<String> user() {
        return Optional.ofNullable(this.user);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RBDVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String fsType;
        private String image;
        @Nullable
        private String keyring;
        private List<String> monitors;
        @Nullable
        private String pool;
        @Nullable
        private Boolean readOnly;
        @Nullable
        private LocalObjectReference secretRef;
        @Nullable
        private String user;

        public Builder() {
        }

        public Builder(RBDVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.fsType = defaults.fsType;
            this.image = defaults.image;
            this.keyring = defaults.keyring;
            this.monitors = defaults.monitors;
            this.pool = defaults.pool;
            this.readOnly = defaults.readOnly;
            this.secretRef = defaults.secretRef;
            this.user = defaults.user;
        }

        @CustomType.Setter
        public Builder fsType(@Nullable String fsType) {
            this.fsType = fsType;
            return this;
        }

        @CustomType.Setter
        public Builder image(String image) {
            if (image == null) {
                throw new MissingRequiredPropertyException("RBDVolumeSource", "image");
            }
            this.image = image;
            return this;
        }

        @CustomType.Setter
        public Builder keyring(@Nullable String keyring) {
            this.keyring = keyring;
            return this;
        }

        @CustomType.Setter
        public Builder monitors(List<String> monitors) {
            if (monitors == null) {
                throw new MissingRequiredPropertyException("RBDVolumeSource", "monitors");
            }
            this.monitors = monitors;
            return this;
        }

        public Builder monitors(String ... monitors) {
            return this.monitors(List.of(monitors));
        }

        @CustomType.Setter
        public Builder pool(@Nullable String pool) {
            this.pool = pool;
            return this;
        }

        @CustomType.Setter
        public Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @CustomType.Setter
        public Builder secretRef(@Nullable LocalObjectReference secretRef) {
            this.secretRef = secretRef;
            return this;
        }

        @CustomType.Setter
        public Builder user(@Nullable String user) {
            this.user = user;
            return this;
        }

        public RBDVolumeSource build() {
            RBDVolumeSource _resultValue = new RBDVolumeSource();
            _resultValue.fsType = this.fsType;
            _resultValue.image = this.image;
            _resultValue.keyring = this.keyring;
            _resultValue.monitors = this.monitors;
            _resultValue.pool = this.pool;
            _resultValue.readOnly = this.readOnly;
            _resultValue.secretRef = this.secretRef;
            _resultValue.user = this.user;
            return _resultValue;
        }
    }
}

