/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.PodTemplateSpec;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ReplicationControllerSpec {
    @Nullable
    private Integer minReadySeconds;
    @Nullable
    private Integer replicas;
    @Nullable
    private Map<String, String> selector;
    @Nullable
    private PodTemplateSpec template;

    private ReplicationControllerSpec() {
    }

    public Optional<Integer> minReadySeconds() {
        return Optional.ofNullable(this.minReadySeconds);
    }

    public Optional<Integer> replicas() {
        return Optional.ofNullable(this.replicas);
    }

    public Map<String, String> selector() {
        return this.selector == null ? Map.of() : this.selector;
    }

    public Optional<PodTemplateSpec> template() {
        return Optional.ofNullable(this.template);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ReplicationControllerSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer minReadySeconds;
        @Nullable
        private Integer replicas;
        @Nullable
        private Map<String, String> selector;
        @Nullable
        private PodTemplateSpec template;

        public Builder() {
        }

        public Builder(ReplicationControllerSpec defaults) {
            Objects.requireNonNull(defaults);
            this.minReadySeconds = defaults.minReadySeconds;
            this.replicas = defaults.replicas;
            this.selector = defaults.selector;
            this.template = defaults.template;
        }

        @CustomType.Setter
        public Builder minReadySeconds(@Nullable Integer minReadySeconds) {
            this.minReadySeconds = minReadySeconds;
            return this;
        }

        @CustomType.Setter
        public Builder replicas(@Nullable Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        @CustomType.Setter
        public Builder selector(@Nullable Map<String, String> selector) {
            this.selector = selector;
            return this;
        }

        @CustomType.Setter
        public Builder template(@Nullable PodTemplateSpec template) {
            this.template = template;
            return this;
        }

        public ReplicationControllerSpec build() {
            ReplicationControllerSpec _resultValue = new ReplicationControllerSpec();
            _resultValue.minReadySeconds = this.minReadySeconds;
            _resultValue.replicas = this.replicas;
            _resultValue.selector = this.selector;
            _resultValue.template = this.template;
            return _resultValue;
        }
    }
}

