/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ResourceHealth {
    @Nullable
    private String health;
    private String resourceID;

    private ResourceHealth() {
    }

    public Optional<String> health() {
        return Optional.ofNullable(this.health);
    }

    public String resourceID() {
        return this.resourceID;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceHealth defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String health;
        private String resourceID;

        public Builder() {
        }

        public Builder(ResourceHealth defaults) {
            Objects.requireNonNull(defaults);
            this.health = defaults.health;
            this.resourceID = defaults.resourceID;
        }

        @CustomType.Setter
        public Builder health(@Nullable String health) {
            this.health = health;
            return this;
        }

        @CustomType.Setter
        public Builder resourceID(String resourceID) {
            if (resourceID == null) {
                throw new MissingRequiredPropertyException("ResourceHealth", "resourceID");
            }
            this.resourceID = resourceID;
            return this;
        }

        public ResourceHealth build() {
            ResourceHealth _resultValue = new ResourceHealth();
            _resultValue.health = this.health;
            _resultValue.resourceID = this.resourceID;
            return _resultValue;
        }
    }
}

