/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.ResourceHealth;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@CustomType
public final class ResourceStatus {
    private String name;
    @Nullable
    private List<ResourceHealth> resources;

    private ResourceStatus() {
    }

    public String name() {
        return this.name;
    }

    public List<ResourceHealth> resources() {
        return this.resources == null ? List.of() : this.resources;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceStatus defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String name;
        @Nullable
        private List<ResourceHealth> resources;

        public Builder() {
        }

        public Builder(ResourceStatus defaults) {
            Objects.requireNonNull(defaults);
            this.name = defaults.name;
            this.resources = defaults.resources;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("ResourceStatus", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder resources(@Nullable List<ResourceHealth> resources) {
            this.resources = resources;
            return this;
        }

        public Builder resources(ResourceHealth ... resources) {
            return this.resources(List.of(resources));
        }

        public ResourceStatus build() {
            ResourceStatus _resultValue = new ResourceStatus();
            _resultValue.name = this.name;
            _resultValue.resources = this.resources;
            return _resultValue;
        }
    }
}

