/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.LocalObjectReference;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ScaleIOVolumeSource {
    @Nullable
    private String fsType;
    private String gateway;
    @Nullable
    private String protectionDomain;
    @Nullable
    private Boolean readOnly;
    private LocalObjectReference secretRef;
    @Nullable
    private Boolean sslEnabled;
    @Nullable
    private String storageMode;
    @Nullable
    private String storagePool;
    private String system;
    @Nullable
    private String volumeName;

    private ScaleIOVolumeSource() {
    }

    public Optional<String> fsType() {
        return Optional.ofNullable(this.fsType);
    }

    public String gateway() {
        return this.gateway;
    }

    public Optional<String> protectionDomain() {
        return Optional.ofNullable(this.protectionDomain);
    }

    public Optional<Boolean> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public LocalObjectReference secretRef() {
        return this.secretRef;
    }

    public Optional<Boolean> sslEnabled() {
        return Optional.ofNullable(this.sslEnabled);
    }

    public Optional<String> storageMode() {
        return Optional.ofNullable(this.storageMode);
    }

    public Optional<String> storagePool() {
        return Optional.ofNullable(this.storagePool);
    }

    public String system() {
        return this.system;
    }

    public Optional<String> volumeName() {
        return Optional.ofNullable(this.volumeName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ScaleIOVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String fsType;
        private String gateway;
        @Nullable
        private String protectionDomain;
        @Nullable
        private Boolean readOnly;
        private LocalObjectReference secretRef;
        @Nullable
        private Boolean sslEnabled;
        @Nullable
        private String storageMode;
        @Nullable
        private String storagePool;
        private String system;
        @Nullable
        private String volumeName;

        public Builder() {
        }

        public Builder(ScaleIOVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.fsType = defaults.fsType;
            this.gateway = defaults.gateway;
            this.protectionDomain = defaults.protectionDomain;
            this.readOnly = defaults.readOnly;
            this.secretRef = defaults.secretRef;
            this.sslEnabled = defaults.sslEnabled;
            this.storageMode = defaults.storageMode;
            this.storagePool = defaults.storagePool;
            this.system = defaults.system;
            this.volumeName = defaults.volumeName;
        }

        @CustomType.Setter
        public Builder fsType(@Nullable String fsType) {
            this.fsType = fsType;
            return this;
        }

        @CustomType.Setter
        public Builder gateway(String gateway) {
            if (gateway == null) {
                throw new MissingRequiredPropertyException("ScaleIOVolumeSource", "gateway");
            }
            this.gateway = gateway;
            return this;
        }

        @CustomType.Setter
        public Builder protectionDomain(@Nullable String protectionDomain) {
            this.protectionDomain = protectionDomain;
            return this;
        }

        @CustomType.Setter
        public Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @CustomType.Setter
        public Builder secretRef(LocalObjectReference secretRef) {
            if (secretRef == null) {
                throw new MissingRequiredPropertyException("ScaleIOVolumeSource", "secretRef");
            }
            this.secretRef = secretRef;
            return this;
        }

        @CustomType.Setter
        public Builder sslEnabled(@Nullable Boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        @CustomType.Setter
        public Builder storageMode(@Nullable String storageMode) {
            this.storageMode = storageMode;
            return this;
        }

        @CustomType.Setter
        public Builder storagePool(@Nullable String storagePool) {
            this.storagePool = storagePool;
            return this;
        }

        @CustomType.Setter
        public Builder system(String system) {
            if (system == null) {
                throw new MissingRequiredPropertyException("ScaleIOVolumeSource", "system");
            }
            this.system = system;
            return this;
        }

        @CustomType.Setter
        public Builder volumeName(@Nullable String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public ScaleIOVolumeSource build() {
            ScaleIOVolumeSource _resultValue = new ScaleIOVolumeSource();
            _resultValue.fsType = this.fsType;
            _resultValue.gateway = this.gateway;
            _resultValue.protectionDomain = this.protectionDomain;
            _resultValue.readOnly = this.readOnly;
            _resultValue.secretRef = this.secretRef;
            _resultValue.sslEnabled = this.sslEnabled;
            _resultValue.storageMode = this.storageMode;
            _resultValue.storagePool = this.storagePool;
            _resultValue.system = this.system;
            _resultValue.volumeName = this.volumeName;
            return _resultValue;
        }
    }
}

