/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@CustomType
public final class ScopedResourceSelectorRequirement {
    private String operator;
    private String scopeName;
    @Nullable
    private List<String> values;

    private ScopedResourceSelectorRequirement() {
    }

    public String operator() {
        return this.operator;
    }

    public String scopeName() {
        return this.scopeName;
    }

    public List<String> values() {
        return this.values == null ? List.of() : this.values;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ScopedResourceSelectorRequirement defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String operator;
        private String scopeName;
        @Nullable
        private List<String> values;

        public Builder() {
        }

        public Builder(ScopedResourceSelectorRequirement defaults) {
            Objects.requireNonNull(defaults);
            this.operator = defaults.operator;
            this.scopeName = defaults.scopeName;
            this.values = defaults.values;
        }

        @CustomType.Setter
        public Builder operator(String operator) {
            if (operator == null) {
                throw new MissingRequiredPropertyException("ScopedResourceSelectorRequirement", "operator");
            }
            this.operator = operator;
            return this;
        }

        @CustomType.Setter
        public Builder scopeName(String scopeName) {
            if (scopeName == null) {
                throw new MissingRequiredPropertyException("ScopedResourceSelectorRequirement", "scopeName");
            }
            this.scopeName = scopeName;
            return this;
        }

        @CustomType.Setter
        public Builder values(@Nullable List<String> values) {
            this.values = values;
            return this;
        }

        public Builder values(String ... values) {
            return this.values(List.of(values));
        }

        public ScopedResourceSelectorRequirement build() {
            ScopedResourceSelectorRequirement _resultValue = new ScopedResourceSelectorRequirement();
            _resultValue.operator = this.operator;
            _resultValue.scopeName = this.scopeName;
            _resultValue.values = this.values;
            return _resultValue;
        }
    }
}

