/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class Secret {
    @Nullable
    private String apiVersion;
    @Nullable
    private Map<String, String> data;
    @Nullable
    private Boolean immutable;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private Map<String, String> stringData;
    @Nullable
    private String type;

    private Secret() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Map<String, String> data() {
        return this.data == null ? Map.of() : this.data;
    }

    public Optional<Boolean> immutable() {
        return Optional.ofNullable(this.immutable);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public Map<String, String> stringData() {
        return this.stringData == null ? Map.of() : this.stringData;
    }

    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Secret defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        @Nullable
        private Map<String, String> data;
        @Nullable
        private Boolean immutable;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private Map<String, String> stringData;
        @Nullable
        private String type;

        public Builder() {
        }

        public Builder(Secret defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.data = defaults.data;
            this.immutable = defaults.immutable;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.stringData = defaults.stringData;
            this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder data(@Nullable Map<String, String> data) {
            this.data = data;
            return this;
        }

        @CustomType.Setter
        public Builder immutable(@Nullable Boolean immutable) {
            this.immutable = immutable;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder stringData(@Nullable Map<String, String> stringData) {
            this.stringData = stringData;
            return this;
        }

        @CustomType.Setter
        public Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public Secret build() {
            Secret _resultValue = new Secret();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.data = this.data;
            _resultValue.immutable = this.immutable;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.stringData = this.stringData;
            _resultValue.type = this.type;
            return _resultValue;
        }
    }
}

