/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.KeyToPath;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class SecretVolumeSource {
    @Nullable
    private Integer defaultMode;
    @Nullable
    private List<KeyToPath> items;
    @Nullable
    private Boolean optional;
    @Nullable
    private String secretName;

    private SecretVolumeSource() {
    }

    public Optional<Integer> defaultMode() {
        return Optional.ofNullable(this.defaultMode);
    }

    public List<KeyToPath> items() {
        return this.items == null ? List.of() : this.items;
    }

    public Optional<Boolean> optional() {
        return Optional.ofNullable(this.optional);
    }

    public Optional<String> secretName() {
        return Optional.ofNullable(this.secretName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SecretVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer defaultMode;
        @Nullable
        private List<KeyToPath> items;
        @Nullable
        private Boolean optional;
        @Nullable
        private String secretName;

        public Builder() {
        }

        public Builder(SecretVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.defaultMode = defaults.defaultMode;
            this.items = defaults.items;
            this.optional = defaults.optional;
            this.secretName = defaults.secretName;
        }

        @CustomType.Setter
        public Builder defaultMode(@Nullable Integer defaultMode) {
            this.defaultMode = defaultMode;
            return this;
        }

        @CustomType.Setter
        public Builder items(@Nullable List<KeyToPath> items) {
            this.items = items;
            return this;
        }

        public Builder items(KeyToPath ... items) {
            return this.items(List.of(items));
        }

        @CustomType.Setter
        public Builder optional(@Nullable Boolean optional) {
            this.optional = optional;
            return this;
        }

        @CustomType.Setter
        public Builder secretName(@Nullable String secretName) {
            this.secretName = secretName;
            return this;
        }

        public SecretVolumeSource build() {
            SecretVolumeSource _resultValue = new SecretVolumeSource();
            _resultValue.defaultMode = this.defaultMode;
            _resultValue.items = this.items;
            _resultValue.optional = this.optional;
            _resultValue.secretName = this.secretName;
            return _resultValue;
        }
    }
}

