/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.AppArmorProfile;
import com.pulumi.kubernetes.core.v1.outputs.Capabilities;
import com.pulumi.kubernetes.core.v1.outputs.SELinuxOptions;
import com.pulumi.kubernetes.core.v1.outputs.SeccompProfile;
import com.pulumi.kubernetes.core.v1.outputs.WindowsSecurityContextOptions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class SecurityContext {
    @Nullable
    private Boolean allowPrivilegeEscalation;
    @Nullable
    private AppArmorProfile appArmorProfile;
    @Nullable
    private Capabilities capabilities;
    @Nullable
    private Boolean privileged;
    @Nullable
    private String procMount;
    @Nullable
    private Boolean readOnlyRootFilesystem;
    @Nullable
    private Integer runAsGroup;
    @Nullable
    private Boolean runAsNonRoot;
    @Nullable
    private Integer runAsUser;
    @Nullable
    private SELinuxOptions seLinuxOptions;
    @Nullable
    private SeccompProfile seccompProfile;
    @Nullable
    private WindowsSecurityContextOptions windowsOptions;

    private SecurityContext() {
    }

    public Optional<Boolean> allowPrivilegeEscalation() {
        return Optional.ofNullable(this.allowPrivilegeEscalation);
    }

    public Optional<AppArmorProfile> appArmorProfile() {
        return Optional.ofNullable(this.appArmorProfile);
    }

    public Optional<Capabilities> capabilities() {
        return Optional.ofNullable(this.capabilities);
    }

    public Optional<Boolean> privileged() {
        return Optional.ofNullable(this.privileged);
    }

    public Optional<String> procMount() {
        return Optional.ofNullable(this.procMount);
    }

    public Optional<Boolean> readOnlyRootFilesystem() {
        return Optional.ofNullable(this.readOnlyRootFilesystem);
    }

    public Optional<Integer> runAsGroup() {
        return Optional.ofNullable(this.runAsGroup);
    }

    public Optional<Boolean> runAsNonRoot() {
        return Optional.ofNullable(this.runAsNonRoot);
    }

    public Optional<Integer> runAsUser() {
        return Optional.ofNullable(this.runAsUser);
    }

    public Optional<SELinuxOptions> seLinuxOptions() {
        return Optional.ofNullable(this.seLinuxOptions);
    }

    public Optional<SeccompProfile> seccompProfile() {
        return Optional.ofNullable(this.seccompProfile);
    }

    public Optional<WindowsSecurityContextOptions> windowsOptions() {
        return Optional.ofNullable(this.windowsOptions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SecurityContext defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean allowPrivilegeEscalation;
        @Nullable
        private AppArmorProfile appArmorProfile;
        @Nullable
        private Capabilities capabilities;
        @Nullable
        private Boolean privileged;
        @Nullable
        private String procMount;
        @Nullable
        private Boolean readOnlyRootFilesystem;
        @Nullable
        private Integer runAsGroup;
        @Nullable
        private Boolean runAsNonRoot;
        @Nullable
        private Integer runAsUser;
        @Nullable
        private SELinuxOptions seLinuxOptions;
        @Nullable
        private SeccompProfile seccompProfile;
        @Nullable
        private WindowsSecurityContextOptions windowsOptions;

        public Builder() {
        }

        public Builder(SecurityContext defaults) {
            Objects.requireNonNull(defaults);
            this.allowPrivilegeEscalation = defaults.allowPrivilegeEscalation;
            this.appArmorProfile = defaults.appArmorProfile;
            this.capabilities = defaults.capabilities;
            this.privileged = defaults.privileged;
            this.procMount = defaults.procMount;
            this.readOnlyRootFilesystem = defaults.readOnlyRootFilesystem;
            this.runAsGroup = defaults.runAsGroup;
            this.runAsNonRoot = defaults.runAsNonRoot;
            this.runAsUser = defaults.runAsUser;
            this.seLinuxOptions = defaults.seLinuxOptions;
            this.seccompProfile = defaults.seccompProfile;
            this.windowsOptions = defaults.windowsOptions;
        }

        @CustomType.Setter
        public Builder allowPrivilegeEscalation(@Nullable Boolean allowPrivilegeEscalation) {
            this.allowPrivilegeEscalation = allowPrivilegeEscalation;
            return this;
        }

        @CustomType.Setter
        public Builder appArmorProfile(@Nullable AppArmorProfile appArmorProfile) {
            this.appArmorProfile = appArmorProfile;
            return this;
        }

        @CustomType.Setter
        public Builder capabilities(@Nullable Capabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @CustomType.Setter
        public Builder privileged(@Nullable Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        @CustomType.Setter
        public Builder procMount(@Nullable String procMount) {
            this.procMount = procMount;
            return this;
        }

        @CustomType.Setter
        public Builder readOnlyRootFilesystem(@Nullable Boolean readOnlyRootFilesystem) {
            this.readOnlyRootFilesystem = readOnlyRootFilesystem;
            return this;
        }

        @CustomType.Setter
        public Builder runAsGroup(@Nullable Integer runAsGroup) {
            this.runAsGroup = runAsGroup;
            return this;
        }

        @CustomType.Setter
        public Builder runAsNonRoot(@Nullable Boolean runAsNonRoot) {
            this.runAsNonRoot = runAsNonRoot;
            return this;
        }

        @CustomType.Setter
        public Builder runAsUser(@Nullable Integer runAsUser) {
            this.runAsUser = runAsUser;
            return this;
        }

        @CustomType.Setter
        public Builder seLinuxOptions(@Nullable SELinuxOptions seLinuxOptions) {
            this.seLinuxOptions = seLinuxOptions;
            return this;
        }

        @CustomType.Setter
        public Builder seccompProfile(@Nullable SeccompProfile seccompProfile) {
            this.seccompProfile = seccompProfile;
            return this;
        }

        @CustomType.Setter
        public Builder windowsOptions(@Nullable WindowsSecurityContextOptions windowsOptions) {
            this.windowsOptions = windowsOptions;
            return this;
        }

        public SecurityContext build() {
            SecurityContext _resultValue = new SecurityContext();
            _resultValue.allowPrivilegeEscalation = this.allowPrivilegeEscalation;
            _resultValue.appArmorProfile = this.appArmorProfile;
            _resultValue.capabilities = this.capabilities;
            _resultValue.privileged = this.privileged;
            _resultValue.procMount = this.procMount;
            _resultValue.readOnlyRootFilesystem = this.readOnlyRootFilesystem;
            _resultValue.runAsGroup = this.runAsGroup;
            _resultValue.runAsNonRoot = this.runAsNonRoot;
            _resultValue.runAsUser = this.runAsUser;
            _resultValue.seLinuxOptions = this.seLinuxOptions;
            _resultValue.seccompProfile = this.seccompProfile;
            _resultValue.windowsOptions = this.windowsOptions;
            return _resultValue;
        }
    }
}

