/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.LocalObjectReference;
import com.pulumi.kubernetes.core.v1.outputs.ObjectReference;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ServiceAccount {
    @Nullable
    private String apiVersion;
    @Nullable
    private Boolean automountServiceAccountToken;
    @Nullable
    private List<LocalObjectReference> imagePullSecrets;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private List<ObjectReference> secrets;

    private ServiceAccount() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<Boolean> automountServiceAccountToken() {
        return Optional.ofNullable(this.automountServiceAccountToken);
    }

    public List<LocalObjectReference> imagePullSecrets() {
        return this.imagePullSecrets == null ? List.of() : this.imagePullSecrets;
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public List<ObjectReference> secrets() {
        return this.secrets == null ? List.of() : this.secrets;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceAccount defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        @Nullable
        private Boolean automountServiceAccountToken;
        @Nullable
        private List<LocalObjectReference> imagePullSecrets;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private List<ObjectReference> secrets;

        public Builder() {
        }

        public Builder(ServiceAccount defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.automountServiceAccountToken = defaults.automountServiceAccountToken;
            this.imagePullSecrets = defaults.imagePullSecrets;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.secrets = defaults.secrets;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder automountServiceAccountToken(@Nullable Boolean automountServiceAccountToken) {
            this.automountServiceAccountToken = automountServiceAccountToken;
            return this;
        }

        @CustomType.Setter
        public Builder imagePullSecrets(@Nullable List<LocalObjectReference> imagePullSecrets) {
            this.imagePullSecrets = imagePullSecrets;
            return this;
        }

        public Builder imagePullSecrets(LocalObjectReference ... imagePullSecrets) {
            return this.imagePullSecrets(List.of(imagePullSecrets));
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder secrets(@Nullable List<ObjectReference> secrets) {
            this.secrets = secrets;
            return this;
        }

        public Builder secrets(ObjectReference ... secrets) {
            return this.secrets(List.of(secrets));
        }

        public ServiceAccount build() {
            ServiceAccount _resultValue = new ServiceAccount();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.automountServiceAccountToken = this.automountServiceAccountToken;
            _resultValue.imagePullSecrets = this.imagePullSecrets;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.secrets = this.secrets;
            return _resultValue;
        }
    }
}

