/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.Either;
import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ServicePort {
    @Nullable
    private String appProtocol;
    @Nullable
    private String name;
    @Nullable
    private Integer nodePort;
    private Integer port;
    @Nullable
    private String protocol;
    @Nullable
    private Either<Integer, String> targetPort;

    private ServicePort() {
    }

    public Optional<String> appProtocol() {
        return Optional.ofNullable(this.appProtocol);
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Integer> nodePort() {
        return Optional.ofNullable(this.nodePort);
    }

    public Integer port() {
        return this.port;
    }

    public Optional<String> protocol() {
        return Optional.ofNullable(this.protocol);
    }

    public Optional<Either<Integer, String>> targetPort() {
        return Optional.ofNullable(this.targetPort);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServicePort defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String appProtocol;
        @Nullable
        private String name;
        @Nullable
        private Integer nodePort;
        private Integer port;
        @Nullable
        private String protocol;
        @Nullable
        private Either<Integer, String> targetPort;

        public Builder() {
        }

        public Builder(ServicePort defaults) {
            Objects.requireNonNull(defaults);
            this.appProtocol = defaults.appProtocol;
            this.name = defaults.name;
            this.nodePort = defaults.nodePort;
            this.port = defaults.port;
            this.protocol = defaults.protocol;
            this.targetPort = defaults.targetPort;
        }

        @CustomType.Setter
        public Builder appProtocol(@Nullable String appProtocol) {
            this.appProtocol = appProtocol;
            return this;
        }

        @CustomType.Setter
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder nodePort(@Nullable Integer nodePort) {
            this.nodePort = nodePort;
            return this;
        }

        @CustomType.Setter
        public Builder port(Integer port) {
            if (port == null) {
                throw new MissingRequiredPropertyException("ServicePort", "port");
            }
            this.port = port;
            return this;
        }

        @CustomType.Setter
        public Builder protocol(@Nullable String protocol) {
            this.protocol = protocol;
            return this;
        }

        @CustomType.Setter
        public Builder targetPort(@Nullable Either<Integer, String> targetPort) {
            this.targetPort = targetPort;
            return this;
        }

        public ServicePort build() {
            ServicePort _resultValue = new ServicePort();
            _resultValue.appProtocol = this.appProtocol;
            _resultValue.name = this.name;
            _resultValue.nodePort = this.nodePort;
            _resultValue.port = this.port;
            _resultValue.protocol = this.protocol;
            _resultValue.targetPort = this.targetPort;
            return _resultValue;
        }
    }
}

