/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.LoadBalancerStatus;
import com.pulumi.kubernetes.meta.v1.outputs.Condition;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ServiceStatus {
    @Nullable
    private List<Condition> conditions;
    @Nullable
    private LoadBalancerStatus loadBalancer;

    private ServiceStatus() {
    }

    public List<Condition> conditions() {
        return this.conditions == null ? List.of() : this.conditions;
    }

    public Optional<LoadBalancerStatus> loadBalancer() {
        return Optional.ofNullable(this.loadBalancer);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceStatus defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<Condition> conditions;
        @Nullable
        private LoadBalancerStatus loadBalancer;

        public Builder() {
        }

        public Builder(ServiceStatus defaults) {
            Objects.requireNonNull(defaults);
            this.conditions = defaults.conditions;
            this.loadBalancer = defaults.loadBalancer;
        }

        @CustomType.Setter
        public Builder conditions(@Nullable List<Condition> conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder conditions(Condition ... conditions) {
            return this.conditions(List.of(conditions));
        }

        @CustomType.Setter
        public Builder loadBalancer(@Nullable LoadBalancerStatus loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        public ServiceStatus build() {
            ServiceStatus _resultValue = new ServiceStatus();
            _resultValue.conditions = this.conditions;
            _resultValue.loadBalancer = this.loadBalancer;
            return _resultValue;
        }
    }
}

