/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.Either;
import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class TCPSocketAction {
    @Nullable
    private String host;
    private Either<Integer, String> port;

    private TCPSocketAction() {
    }

    public Optional<String> host() {
        return Optional.ofNullable(this.host);
    }

    public Either<Integer, String> port() {
        return this.port;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TCPSocketAction defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String host;
        private Either<Integer, String> port;

        public Builder() {
        }

        public Builder(TCPSocketAction defaults) {
            Objects.requireNonNull(defaults);
            this.host = defaults.host;
            this.port = defaults.port;
        }

        @CustomType.Setter
        public Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        @CustomType.Setter
        public Builder port(Either<Integer, String> port) {
            if (port == null) {
                throw new MissingRequiredPropertyException("TCPSocketAction", "port");
            }
            this.port = port;
            return this;
        }

        public TCPSocketAction build() {
            TCPSocketAction _resultValue = new TCPSocketAction();
            _resultValue.host = this.host;
            _resultValue.port = this.port;
            return _resultValue;
        }
    }
}

