/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class TopologySpreadConstraint {
    @Nullable
    private LabelSelector labelSelector;
    @Nullable
    private List<String> matchLabelKeys;
    private Integer maxSkew;
    @Nullable
    private Integer minDomains;
    @Nullable
    private String nodeAffinityPolicy;
    @Nullable
    private String nodeTaintsPolicy;
    private String topologyKey;
    private String whenUnsatisfiable;

    private TopologySpreadConstraint() {
    }

    public Optional<LabelSelector> labelSelector() {
        return Optional.ofNullable(this.labelSelector);
    }

    public List<String> matchLabelKeys() {
        return this.matchLabelKeys == null ? List.of() : this.matchLabelKeys;
    }

    public Integer maxSkew() {
        return this.maxSkew;
    }

    public Optional<Integer> minDomains() {
        return Optional.ofNullable(this.minDomains);
    }

    public Optional<String> nodeAffinityPolicy() {
        return Optional.ofNullable(this.nodeAffinityPolicy);
    }

    public Optional<String> nodeTaintsPolicy() {
        return Optional.ofNullable(this.nodeTaintsPolicy);
    }

    public String topologyKey() {
        return this.topologyKey;
    }

    public String whenUnsatisfiable() {
        return this.whenUnsatisfiable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TopologySpreadConstraint defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private LabelSelector labelSelector;
        @Nullable
        private List<String> matchLabelKeys;
        private Integer maxSkew;
        @Nullable
        private Integer minDomains;
        @Nullable
        private String nodeAffinityPolicy;
        @Nullable
        private String nodeTaintsPolicy;
        private String topologyKey;
        private String whenUnsatisfiable;

        public Builder() {
        }

        public Builder(TopologySpreadConstraint defaults) {
            Objects.requireNonNull(defaults);
            this.labelSelector = defaults.labelSelector;
            this.matchLabelKeys = defaults.matchLabelKeys;
            this.maxSkew = defaults.maxSkew;
            this.minDomains = defaults.minDomains;
            this.nodeAffinityPolicy = defaults.nodeAffinityPolicy;
            this.nodeTaintsPolicy = defaults.nodeTaintsPolicy;
            this.topologyKey = defaults.topologyKey;
            this.whenUnsatisfiable = defaults.whenUnsatisfiable;
        }

        @CustomType.Setter
        public Builder labelSelector(@Nullable LabelSelector labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        @CustomType.Setter
        public Builder matchLabelKeys(@Nullable List<String> matchLabelKeys) {
            this.matchLabelKeys = matchLabelKeys;
            return this;
        }

        public Builder matchLabelKeys(String ... matchLabelKeys) {
            return this.matchLabelKeys(List.of(matchLabelKeys));
        }

        @CustomType.Setter
        public Builder maxSkew(Integer maxSkew) {
            if (maxSkew == null) {
                throw new MissingRequiredPropertyException("TopologySpreadConstraint", "maxSkew");
            }
            this.maxSkew = maxSkew;
            return this;
        }

        @CustomType.Setter
        public Builder minDomains(@Nullable Integer minDomains) {
            this.minDomains = minDomains;
            return this;
        }

        @CustomType.Setter
        public Builder nodeAffinityPolicy(@Nullable String nodeAffinityPolicy) {
            this.nodeAffinityPolicy = nodeAffinityPolicy;
            return this;
        }

        @CustomType.Setter
        public Builder nodeTaintsPolicy(@Nullable String nodeTaintsPolicy) {
            this.nodeTaintsPolicy = nodeTaintsPolicy;
            return this;
        }

        @CustomType.Setter
        public Builder topologyKey(String topologyKey) {
            if (topologyKey == null) {
                throw new MissingRequiredPropertyException("TopologySpreadConstraint", "topologyKey");
            }
            this.topologyKey = topologyKey;
            return this;
        }

        @CustomType.Setter
        public Builder whenUnsatisfiable(String whenUnsatisfiable) {
            if (whenUnsatisfiable == null) {
                throw new MissingRequiredPropertyException("TopologySpreadConstraint", "whenUnsatisfiable");
            }
            this.whenUnsatisfiable = whenUnsatisfiable;
            return this;
        }

        public TopologySpreadConstraint build() {
            TopologySpreadConstraint _resultValue = new TopologySpreadConstraint();
            _resultValue.labelSelector = this.labelSelector;
            _resultValue.matchLabelKeys = this.matchLabelKeys;
            _resultValue.maxSkew = this.maxSkew;
            _resultValue.minDomains = this.minDomains;
            _resultValue.nodeAffinityPolicy = this.nodeAffinityPolicy;
            _resultValue.nodeTaintsPolicy = this.nodeTaintsPolicy;
            _resultValue.topologyKey = this.topologyKey;
            _resultValue.whenUnsatisfiable = this.whenUnsatisfiable;
            return _resultValue;
        }
    }
}

