/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class TypedLocalObjectReference {
    @Nullable
    private String apiGroup;
    private String kind;
    private String name;

    private TypedLocalObjectReference() {
    }

    public Optional<String> apiGroup() {
        return Optional.ofNullable(this.apiGroup);
    }

    public String kind() {
        return this.kind;
    }

    public String name() {
        return this.name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TypedLocalObjectReference defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiGroup;
        private String kind;
        private String name;

        public Builder() {
        }

        public Builder(TypedLocalObjectReference defaults) {
            Objects.requireNonNull(defaults);
            this.apiGroup = defaults.apiGroup;
            this.kind = defaults.kind;
            this.name = defaults.name;
        }

        @CustomType.Setter
        public Builder apiGroup(@Nullable String apiGroup) {
            this.apiGroup = apiGroup;
            return this;
        }

        @CustomType.Setter
        public Builder kind(String kind) {
            if (kind == null) {
                throw new MissingRequiredPropertyException("TypedLocalObjectReference", "kind");
            }
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("TypedLocalObjectReference", "name");
            }
            this.name = name;
            return this;
        }

        public TypedLocalObjectReference build() {
            TypedLocalObjectReference _resultValue = new TypedLocalObjectReference();
            _resultValue.apiGroup = this.apiGroup;
            _resultValue.kind = this.kind;
            _resultValue.name = this.name;
            return _resultValue;
        }
    }
}

