/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class VolumeMount {
    private String mountPath;
    @Nullable
    private String mountPropagation;
    private String name;
    @Nullable
    private Boolean readOnly;
    @Nullable
    private String recursiveReadOnly;
    @Nullable
    private String subPath;
    @Nullable
    private String subPathExpr;

    private VolumeMount() {
    }

    public String mountPath() {
        return this.mountPath;
    }

    public Optional<String> mountPropagation() {
        return Optional.ofNullable(this.mountPropagation);
    }

    public String name() {
        return this.name;
    }

    public Optional<Boolean> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public Optional<String> recursiveReadOnly() {
        return Optional.ofNullable(this.recursiveReadOnly);
    }

    public Optional<String> subPath() {
        return Optional.ofNullable(this.subPath);
    }

    public Optional<String> subPathExpr() {
        return Optional.ofNullable(this.subPathExpr);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(VolumeMount defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String mountPath;
        @Nullable
        private String mountPropagation;
        private String name;
        @Nullable
        private Boolean readOnly;
        @Nullable
        private String recursiveReadOnly;
        @Nullable
        private String subPath;
        @Nullable
        private String subPathExpr;

        public Builder() {
        }

        public Builder(VolumeMount defaults) {
            Objects.requireNonNull(defaults);
            this.mountPath = defaults.mountPath;
            this.mountPropagation = defaults.mountPropagation;
            this.name = defaults.name;
            this.readOnly = defaults.readOnly;
            this.recursiveReadOnly = defaults.recursiveReadOnly;
            this.subPath = defaults.subPath;
            this.subPathExpr = defaults.subPathExpr;
        }

        @CustomType.Setter
        public Builder mountPath(String mountPath) {
            if (mountPath == null) {
                throw new MissingRequiredPropertyException("VolumeMount", "mountPath");
            }
            this.mountPath = mountPath;
            return this;
        }

        @CustomType.Setter
        public Builder mountPropagation(@Nullable String mountPropagation) {
            this.mountPropagation = mountPropagation;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("VolumeMount", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @CustomType.Setter
        public Builder recursiveReadOnly(@Nullable String recursiveReadOnly) {
            this.recursiveReadOnly = recursiveReadOnly;
            return this;
        }

        @CustomType.Setter
        public Builder subPath(@Nullable String subPath) {
            this.subPath = subPath;
            return this;
        }

        @CustomType.Setter
        public Builder subPathExpr(@Nullable String subPathExpr) {
            this.subPathExpr = subPathExpr;
            return this;
        }

        public VolumeMount build() {
            VolumeMount _resultValue = new VolumeMount();
            _resultValue.mountPath = this.mountPath;
            _resultValue.mountPropagation = this.mountPropagation;
            _resultValue.name = this.name;
            _resultValue.readOnly = this.readOnly;
            _resultValue.recursiveReadOnly = this.recursiveReadOnly;
            _resultValue.subPath = this.subPath;
            _resultValue.subPathExpr = this.subPathExpr;
            return _resultValue;
        }
    }
}

