/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class VolumeMountStatus {
    private String mountPath;
    private String name;
    @Nullable
    private Boolean readOnly;
    @Nullable
    private String recursiveReadOnly;

    private VolumeMountStatus() {
    }

    public String mountPath() {
        return this.mountPath;
    }

    public String name() {
        return this.name;
    }

    public Optional<Boolean> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public Optional<String> recursiveReadOnly() {
        return Optional.ofNullable(this.recursiveReadOnly);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(VolumeMountStatus defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String mountPath;
        private String name;
        @Nullable
        private Boolean readOnly;
        @Nullable
        private String recursiveReadOnly;

        public Builder() {
        }

        public Builder(VolumeMountStatus defaults) {
            Objects.requireNonNull(defaults);
            this.mountPath = defaults.mountPath;
            this.name = defaults.name;
            this.readOnly = defaults.readOnly;
            this.recursiveReadOnly = defaults.recursiveReadOnly;
        }

        @CustomType.Setter
        public Builder mountPath(String mountPath) {
            if (mountPath == null) {
                throw new MissingRequiredPropertyException("VolumeMountStatus", "mountPath");
            }
            this.mountPath = mountPath;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("VolumeMountStatus", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @CustomType.Setter
        public Builder recursiveReadOnly(@Nullable String recursiveReadOnly) {
            this.recursiveReadOnly = recursiveReadOnly;
            return this;
        }

        public VolumeMountStatus build() {
            VolumeMountStatus _resultValue = new VolumeMountStatus();
            _resultValue.mountPath = this.mountPath;
            _resultValue.name = this.name;
            _resultValue.readOnly = this.readOnly;
            _resultValue.recursiveReadOnly = this.recursiveReadOnly;
            return _resultValue;
        }
    }
}

