/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.discovery.v1;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.core.internal.Codegen;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.discovery.v1.inputs.EndpointArgs;
import com.pulumi.kubernetes.discovery.v1.inputs.EndpointPortArgs;
import com.pulumi.kubernetes.meta.v1.inputs.ObjectMetaArgs;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class EndpointSliceArgs
extends ResourceArgs {
    public static final EndpointSliceArgs Empty = new EndpointSliceArgs();
    @Import(name="addressType", required=true)
    private Output<String> addressType;
    @Import(name="apiVersion")
    @Nullable
    private Output<String> apiVersion;
    @Import(name="endpoints", required=true)
    private Output<List<EndpointArgs>> endpoints;
    @Import(name="kind")
    @Nullable
    private Output<String> kind;
    @Import(name="metadata")
    @Nullable
    private Output<ObjectMetaArgs> metadata;
    @Import(name="ports")
    @Nullable
    private Output<List<EndpointPortArgs>> ports;

    public Output<String> addressType() {
        return this.addressType;
    }

    public Optional<Output<String>> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Output<List<EndpointArgs>> endpoints() {
        return this.endpoints;
    }

    public Optional<Output<String>> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<Output<ObjectMetaArgs>> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public Optional<Output<List<EndpointPortArgs>>> ports() {
        return Optional.ofNullable(this.ports);
    }

    private EndpointSliceArgs() {
    }

    private EndpointSliceArgs(EndpointSliceArgs $) {
        this.addressType = $.addressType;
        this.apiVersion = $.apiVersion;
        this.endpoints = $.endpoints;
        this.kind = $.kind;
        this.metadata = $.metadata;
        this.ports = $.ports;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EndpointSliceArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EndpointSliceArgs $;

        public Builder() {
            this.$ = new EndpointSliceArgs();
        }

        public Builder(EndpointSliceArgs defaults) {
            this.$ = new EndpointSliceArgs(Objects.requireNonNull(defaults));
        }

        public Builder addressType(Output<String> addressType) {
            this.$.addressType = addressType;
            return this;
        }

        public Builder addressType(String addressType) {
            return this.addressType((Output<String>)Output.of((Object)addressType));
        }

        public Builder apiVersion(@Nullable Output<String> apiVersion) {
            this.$.apiVersion = apiVersion;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            return this.apiVersion((Output<String>)Output.of((Object)apiVersion));
        }

        public Builder endpoints(Output<List<EndpointArgs>> endpoints) {
            this.$.endpoints = endpoints;
            return this;
        }

        public Builder endpoints(List<EndpointArgs> endpoints) {
            return this.endpoints((Output<List<EndpointArgs>>)Output.of(endpoints));
        }

        public Builder endpoints(EndpointArgs ... endpoints) {
            return this.endpoints(List.of(endpoints));
        }

        public Builder kind(@Nullable Output<String> kind) {
            this.$.kind = kind;
            return this;
        }

        public Builder kind(String kind) {
            return this.kind((Output<String>)Output.of((Object)kind));
        }

        public Builder metadata(@Nullable Output<ObjectMetaArgs> metadata) {
            this.$.metadata = metadata;
            return this;
        }

        public Builder metadata(ObjectMetaArgs metadata) {
            return this.metadata((Output<ObjectMetaArgs>)Output.of((Object)((Object)metadata)));
        }

        public Builder ports(@Nullable Output<List<EndpointPortArgs>> ports) {
            this.$.ports = ports;
            return this;
        }

        public Builder ports(List<EndpointPortArgs> ports) {
            return this.ports((Output<List<EndpointPortArgs>>)Output.of(ports));
        }

        public Builder ports(EndpointPortArgs ... ports) {
            return this.ports(List.of(ports));
        }

        public EndpointSliceArgs build() {
            if (this.$.addressType == null) {
                throw new MissingRequiredPropertyException("EndpointSliceArgs", "addressType");
            }
            this.$.apiVersion = (Output)Codegen.stringProp((String)"apiVersion").output().arg(this.$.apiVersion).getNullable();
            if (this.$.endpoints == null) {
                throw new MissingRequiredPropertyException("EndpointSliceArgs", "endpoints");
            }
            this.$.kind = (Output)Codegen.stringProp((String)"kind").output().arg(this.$.kind).getNullable();
            return this.$;
        }
    }
}

