/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.discovery.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.inputs.ObjectReferenceArgs;
import com.pulumi.kubernetes.discovery.v1.inputs.EndpointConditionsArgs;
import com.pulumi.kubernetes.discovery.v1.inputs.EndpointHintsArgs;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class EndpointArgs
extends ResourceArgs {
    public static final EndpointArgs Empty = new EndpointArgs();
    @Import(name="addresses", required=true)
    private Output<List<String>> addresses;
    @Import(name="conditions")
    @Nullable
    private Output<EndpointConditionsArgs> conditions;
    @Import(name="deprecatedTopology")
    @Nullable
    private Output<Map<String, String>> deprecatedTopology;
    @Import(name="hints")
    @Nullable
    private Output<EndpointHintsArgs> hints;
    @Import(name="hostname")
    @Nullable
    private Output<String> hostname;
    @Import(name="nodeName")
    @Nullable
    private Output<String> nodeName;
    @Import(name="targetRef")
    @Nullable
    private Output<ObjectReferenceArgs> targetRef;
    @Import(name="zone")
    @Nullable
    private Output<String> zone;

    public Output<List<String>> addresses() {
        return this.addresses;
    }

    public Optional<Output<EndpointConditionsArgs>> conditions() {
        return Optional.ofNullable(this.conditions);
    }

    public Optional<Output<Map<String, String>>> deprecatedTopology() {
        return Optional.ofNullable(this.deprecatedTopology);
    }

    public Optional<Output<EndpointHintsArgs>> hints() {
        return Optional.ofNullable(this.hints);
    }

    public Optional<Output<String>> hostname() {
        return Optional.ofNullable(this.hostname);
    }

    public Optional<Output<String>> nodeName() {
        return Optional.ofNullable(this.nodeName);
    }

    public Optional<Output<ObjectReferenceArgs>> targetRef() {
        return Optional.ofNullable(this.targetRef);
    }

    public Optional<Output<String>> zone() {
        return Optional.ofNullable(this.zone);
    }

    private EndpointArgs() {
    }

    private EndpointArgs(EndpointArgs $) {
        this.addresses = $.addresses;
        this.conditions = $.conditions;
        this.deprecatedTopology = $.deprecatedTopology;
        this.hints = $.hints;
        this.hostname = $.hostname;
        this.nodeName = $.nodeName;
        this.targetRef = $.targetRef;
        this.zone = $.zone;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EndpointArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EndpointArgs $;

        public Builder() {
            this.$ = new EndpointArgs();
        }

        public Builder(EndpointArgs defaults) {
            this.$ = new EndpointArgs(Objects.requireNonNull(defaults));
        }

        public Builder addresses(Output<List<String>> addresses) {
            this.$.addresses = addresses;
            return this;
        }

        public Builder addresses(List<String> addresses) {
            return this.addresses((Output<List<String>>)Output.of(addresses));
        }

        public Builder addresses(String ... addresses) {
            return this.addresses(List.of(addresses));
        }

        public Builder conditions(@Nullable Output<EndpointConditionsArgs> conditions) {
            this.$.conditions = conditions;
            return this;
        }

        public Builder conditions(EndpointConditionsArgs conditions) {
            return this.conditions((Output<EndpointConditionsArgs>)Output.of((Object)((Object)conditions)));
        }

        public Builder deprecatedTopology(@Nullable Output<Map<String, String>> deprecatedTopology) {
            this.$.deprecatedTopology = deprecatedTopology;
            return this;
        }

        public Builder deprecatedTopology(Map<String, String> deprecatedTopology) {
            return this.deprecatedTopology((Output<Map<String, String>>)Output.of(deprecatedTopology));
        }

        public Builder hints(@Nullable Output<EndpointHintsArgs> hints) {
            this.$.hints = hints;
            return this;
        }

        public Builder hints(EndpointHintsArgs hints) {
            return this.hints((Output<EndpointHintsArgs>)Output.of((Object)((Object)hints)));
        }

        public Builder hostname(@Nullable Output<String> hostname) {
            this.$.hostname = hostname;
            return this;
        }

        public Builder hostname(String hostname) {
            return this.hostname((Output<String>)Output.of((Object)hostname));
        }

        public Builder nodeName(@Nullable Output<String> nodeName) {
            this.$.nodeName = nodeName;
            return this;
        }

        public Builder nodeName(String nodeName) {
            return this.nodeName((Output<String>)Output.of((Object)nodeName));
        }

        public Builder targetRef(@Nullable Output<ObjectReferenceArgs> targetRef) {
            this.$.targetRef = targetRef;
            return this;
        }

        public Builder targetRef(ObjectReferenceArgs targetRef) {
            return this.targetRef((Output<ObjectReferenceArgs>)Output.of((Object)((Object)targetRef)));
        }

        public Builder zone(@Nullable Output<String> zone) {
            this.$.zone = zone;
            return this;
        }

        public Builder zone(String zone) {
            return this.zone((Output<String>)Output.of((Object)zone));
        }

        public EndpointArgs build() {
            if (this.$.addresses == null) {
                throw new MissingRequiredPropertyException("EndpointArgs", "addresses");
            }
            return this.$;
        }
    }
}

