/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.discovery.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.ObjectReferencePatch;
import com.pulumi.kubernetes.discovery.v1.outputs.EndpointConditionsPatch;
import com.pulumi.kubernetes.discovery.v1.outputs.EndpointHintsPatch;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EndpointPatch {
    @Nullable
    private List<String> addresses;
    @Nullable
    private EndpointConditionsPatch conditions;
    @Nullable
    private Map<String, String> deprecatedTopology;
    @Nullable
    private EndpointHintsPatch hints;
    @Nullable
    private String hostname;
    @Nullable
    private String nodeName;
    @Nullable
    private ObjectReferencePatch targetRef;
    @Nullable
    private String zone;

    private EndpointPatch() {
    }

    public List<String> addresses() {
        return this.addresses == null ? List.of() : this.addresses;
    }

    public Optional<EndpointConditionsPatch> conditions() {
        return Optional.ofNullable(this.conditions);
    }

    public Map<String, String> deprecatedTopology() {
        return this.deprecatedTopology == null ? Map.of() : this.deprecatedTopology;
    }

    public Optional<EndpointHintsPatch> hints() {
        return Optional.ofNullable(this.hints);
    }

    public Optional<String> hostname() {
        return Optional.ofNullable(this.hostname);
    }

    public Optional<String> nodeName() {
        return Optional.ofNullable(this.nodeName);
    }

    public Optional<ObjectReferencePatch> targetRef() {
        return Optional.ofNullable(this.targetRef);
    }

    public Optional<String> zone() {
        return Optional.ofNullable(this.zone);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EndpointPatch defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<String> addresses;
        @Nullable
        private EndpointConditionsPatch conditions;
        @Nullable
        private Map<String, String> deprecatedTopology;
        @Nullable
        private EndpointHintsPatch hints;
        @Nullable
        private String hostname;
        @Nullable
        private String nodeName;
        @Nullable
        private ObjectReferencePatch targetRef;
        @Nullable
        private String zone;

        public Builder() {
        }

        public Builder(EndpointPatch defaults) {
            Objects.requireNonNull(defaults);
            this.addresses = defaults.addresses;
            this.conditions = defaults.conditions;
            this.deprecatedTopology = defaults.deprecatedTopology;
            this.hints = defaults.hints;
            this.hostname = defaults.hostname;
            this.nodeName = defaults.nodeName;
            this.targetRef = defaults.targetRef;
            this.zone = defaults.zone;
        }

        @CustomType.Setter
        public Builder addresses(@Nullable List<String> addresses) {
            this.addresses = addresses;
            return this;
        }

        public Builder addresses(String ... addresses) {
            return this.addresses(List.of(addresses));
        }

        @CustomType.Setter
        public Builder conditions(@Nullable EndpointConditionsPatch conditions) {
            this.conditions = conditions;
            return this;
        }

        @CustomType.Setter
        public Builder deprecatedTopology(@Nullable Map<String, String> deprecatedTopology) {
            this.deprecatedTopology = deprecatedTopology;
            return this;
        }

        @CustomType.Setter
        public Builder hints(@Nullable EndpointHintsPatch hints) {
            this.hints = hints;
            return this;
        }

        @CustomType.Setter
        public Builder hostname(@Nullable String hostname) {
            this.hostname = hostname;
            return this;
        }

        @CustomType.Setter
        public Builder nodeName(@Nullable String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        @CustomType.Setter
        public Builder targetRef(@Nullable ObjectReferencePatch targetRef) {
            this.targetRef = targetRef;
            return this;
        }

        @CustomType.Setter
        public Builder zone(@Nullable String zone) {
            this.zone = zone;
            return this;
        }

        public EndpointPatch build() {
            EndpointPatch _resultValue = new EndpointPatch();
            _resultValue.addresses = this.addresses;
            _resultValue.conditions = this.conditions;
            _resultValue.deprecatedTopology = this.deprecatedTopology;
            _resultValue.hints = this.hints;
            _resultValue.hostname = this.hostname;
            _resultValue.nodeName = this.nodeName;
            _resultValue.targetRef = this.targetRef;
            _resultValue.zone = this.zone;
            return _resultValue;
        }
    }
}

