/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.discovery.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.discovery.v1.outputs.Endpoint;
import com.pulumi.kubernetes.discovery.v1.outputs.EndpointPort;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EndpointSlice {
    private String addressType;
    @Nullable
    private String apiVersion;
    private List<Endpoint> endpoints;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private List<EndpointPort> ports;

    private EndpointSlice() {
    }

    public String addressType() {
        return this.addressType;
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public List<Endpoint> endpoints() {
        return this.endpoints;
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public List<EndpointPort> ports() {
        return this.ports == null ? List.of() : this.ports;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EndpointSlice defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String addressType;
        @Nullable
        private String apiVersion;
        private List<Endpoint> endpoints;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private List<EndpointPort> ports;

        public Builder() {
        }

        public Builder(EndpointSlice defaults) {
            Objects.requireNonNull(defaults);
            this.addressType = defaults.addressType;
            this.apiVersion = defaults.apiVersion;
            this.endpoints = defaults.endpoints;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.ports = defaults.ports;
        }

        @CustomType.Setter
        public Builder addressType(String addressType) {
            if (addressType == null) {
                throw new MissingRequiredPropertyException("EndpointSlice", "addressType");
            }
            this.addressType = addressType;
            return this;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder endpoints(List<Endpoint> endpoints) {
            if (endpoints == null) {
                throw new MissingRequiredPropertyException("EndpointSlice", "endpoints");
            }
            this.endpoints = endpoints;
            return this;
        }

        public Builder endpoints(Endpoint ... endpoints) {
            return this.endpoints(List.of(endpoints));
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder ports(@Nullable List<EndpointPort> ports) {
            this.ports = ports;
            return this;
        }

        public Builder ports(EndpointPort ... ports) {
            return this.ports(List.of(ports));
        }

        public EndpointSlice build() {
            EndpointSlice _resultValue = new EndpointSlice();
            _resultValue.addressType = this.addressType;
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.endpoints = this.endpoints;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.ports = this.ports;
            return _resultValue;
        }
    }
}

