/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.discovery.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.ObjectReference;
import com.pulumi.kubernetes.discovery.v1beta1.outputs.EndpointConditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class Endpoint {
    private List<String> addresses;
    @Nullable
    private EndpointConditions conditions;
    @Nullable
    private String hostname;
    @Nullable
    private String nodeName;
    @Nullable
    private ObjectReference targetRef;
    @Nullable
    private Map<String, String> topology;

    private Endpoint() {
    }

    public List<String> addresses() {
        return this.addresses;
    }

    public Optional<EndpointConditions> conditions() {
        return Optional.ofNullable(this.conditions);
    }

    public Optional<String> hostname() {
        return Optional.ofNullable(this.hostname);
    }

    public Optional<String> nodeName() {
        return Optional.ofNullable(this.nodeName);
    }

    public Optional<ObjectReference> targetRef() {
        return Optional.ofNullable(this.targetRef);
    }

    public Map<String, String> topology() {
        return this.topology == null ? Map.of() : this.topology;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Endpoint defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> addresses;
        @Nullable
        private EndpointConditions conditions;
        @Nullable
        private String hostname;
        @Nullable
        private String nodeName;
        @Nullable
        private ObjectReference targetRef;
        @Nullable
        private Map<String, String> topology;

        public Builder() {
        }

        public Builder(Endpoint defaults) {
            Objects.requireNonNull(defaults);
            this.addresses = defaults.addresses;
            this.conditions = defaults.conditions;
            this.hostname = defaults.hostname;
            this.nodeName = defaults.nodeName;
            this.targetRef = defaults.targetRef;
            this.topology = defaults.topology;
        }

        @CustomType.Setter
        public Builder addresses(List<String> addresses) {
            if (addresses == null) {
                throw new MissingRequiredPropertyException("Endpoint", "addresses");
            }
            this.addresses = addresses;
            return this;
        }

        public Builder addresses(String ... addresses) {
            return this.addresses(List.of(addresses));
        }

        @CustomType.Setter
        public Builder conditions(@Nullable EndpointConditions conditions) {
            this.conditions = conditions;
            return this;
        }

        @CustomType.Setter
        public Builder hostname(@Nullable String hostname) {
            this.hostname = hostname;
            return this;
        }

        @CustomType.Setter
        public Builder nodeName(@Nullable String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        @CustomType.Setter
        public Builder targetRef(@Nullable ObjectReference targetRef) {
            this.targetRef = targetRef;
            return this;
        }

        @CustomType.Setter
        public Builder topology(@Nullable Map<String, String> topology) {
            this.topology = topology;
            return this;
        }

        public Endpoint build() {
            Endpoint _resultValue = new Endpoint();
            _resultValue.addresses = this.addresses;
            _resultValue.conditions = this.conditions;
            _resultValue.hostname = this.hostname;
            _resultValue.nodeName = this.nodeName;
            _resultValue.targetRef = this.targetRef;
            _resultValue.topology = this.topology;
            return _resultValue;
        }
    }
}

