/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.events.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.EventSource;
import com.pulumi.kubernetes.core.v1.outputs.ObjectReference;
import com.pulumi.kubernetes.events.v1beta1.outputs.EventSeries;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class Event {
    @Nullable
    private String action;
    @Nullable
    private String apiVersion;
    @Nullable
    private Integer deprecatedCount;
    @Nullable
    private String deprecatedFirstTimestamp;
    @Nullable
    private String deprecatedLastTimestamp;
    @Nullable
    private EventSource deprecatedSource;
    private String eventTime;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private String note;
    @Nullable
    private String reason;
    @Nullable
    private ObjectReference regarding;
    @Nullable
    private ObjectReference related;
    @Nullable
    private String reportingController;
    @Nullable
    private String reportingInstance;
    @Nullable
    private EventSeries series;
    @Nullable
    private String type;

    private Event() {
    }

    public Optional<String> action() {
        return Optional.ofNullable(this.action);
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<Integer> deprecatedCount() {
        return Optional.ofNullable(this.deprecatedCount);
    }

    public Optional<String> deprecatedFirstTimestamp() {
        return Optional.ofNullable(this.deprecatedFirstTimestamp);
    }

    public Optional<String> deprecatedLastTimestamp() {
        return Optional.ofNullable(this.deprecatedLastTimestamp);
    }

    public Optional<EventSource> deprecatedSource() {
        return Optional.ofNullable(this.deprecatedSource);
    }

    public String eventTime() {
        return this.eventTime;
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public Optional<String> note() {
        return Optional.ofNullable(this.note);
    }

    public Optional<String> reason() {
        return Optional.ofNullable(this.reason);
    }

    public Optional<ObjectReference> regarding() {
        return Optional.ofNullable(this.regarding);
    }

    public Optional<ObjectReference> related() {
        return Optional.ofNullable(this.related);
    }

    public Optional<String> reportingController() {
        return Optional.ofNullable(this.reportingController);
    }

    public Optional<String> reportingInstance() {
        return Optional.ofNullable(this.reportingInstance);
    }

    public Optional<EventSeries> series() {
        return Optional.ofNullable(this.series);
    }

    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Event defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String action;
        @Nullable
        private String apiVersion;
        @Nullable
        private Integer deprecatedCount;
        @Nullable
        private String deprecatedFirstTimestamp;
        @Nullable
        private String deprecatedLastTimestamp;
        @Nullable
        private EventSource deprecatedSource;
        private String eventTime;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private String note;
        @Nullable
        private String reason;
        @Nullable
        private ObjectReference regarding;
        @Nullable
        private ObjectReference related;
        @Nullable
        private String reportingController;
        @Nullable
        private String reportingInstance;
        @Nullable
        private EventSeries series;
        @Nullable
        private String type;

        public Builder() {
        }

        public Builder(Event defaults) {
            Objects.requireNonNull(defaults);
            this.action = defaults.action;
            this.apiVersion = defaults.apiVersion;
            this.deprecatedCount = defaults.deprecatedCount;
            this.deprecatedFirstTimestamp = defaults.deprecatedFirstTimestamp;
            this.deprecatedLastTimestamp = defaults.deprecatedLastTimestamp;
            this.deprecatedSource = defaults.deprecatedSource;
            this.eventTime = defaults.eventTime;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.note = defaults.note;
            this.reason = defaults.reason;
            this.regarding = defaults.regarding;
            this.related = defaults.related;
            this.reportingController = defaults.reportingController;
            this.reportingInstance = defaults.reportingInstance;
            this.series = defaults.series;
            this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder action(@Nullable String action) {
            this.action = action;
            return this;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder deprecatedCount(@Nullable Integer deprecatedCount) {
            this.deprecatedCount = deprecatedCount;
            return this;
        }

        @CustomType.Setter
        public Builder deprecatedFirstTimestamp(@Nullable String deprecatedFirstTimestamp) {
            this.deprecatedFirstTimestamp = deprecatedFirstTimestamp;
            return this;
        }

        @CustomType.Setter
        public Builder deprecatedLastTimestamp(@Nullable String deprecatedLastTimestamp) {
            this.deprecatedLastTimestamp = deprecatedLastTimestamp;
            return this;
        }

        @CustomType.Setter
        public Builder deprecatedSource(@Nullable EventSource deprecatedSource) {
            this.deprecatedSource = deprecatedSource;
            return this;
        }

        @CustomType.Setter
        public Builder eventTime(String eventTime) {
            if (eventTime == null) {
                throw new MissingRequiredPropertyException("Event", "eventTime");
            }
            this.eventTime = eventTime;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder note(@Nullable String note) {
            this.note = note;
            return this;
        }

        @CustomType.Setter
        public Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CustomType.Setter
        public Builder regarding(@Nullable ObjectReference regarding) {
            this.regarding = regarding;
            return this;
        }

        @CustomType.Setter
        public Builder related(@Nullable ObjectReference related) {
            this.related = related;
            return this;
        }

        @CustomType.Setter
        public Builder reportingController(@Nullable String reportingController) {
            this.reportingController = reportingController;
            return this;
        }

        @CustomType.Setter
        public Builder reportingInstance(@Nullable String reportingInstance) {
            this.reportingInstance = reportingInstance;
            return this;
        }

        @CustomType.Setter
        public Builder series(@Nullable EventSeries series) {
            this.series = series;
            return this;
        }

        @CustomType.Setter
        public Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public Event build() {
            Event _resultValue = new Event();
            _resultValue.action = this.action;
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.deprecatedCount = this.deprecatedCount;
            _resultValue.deprecatedFirstTimestamp = this.deprecatedFirstTimestamp;
            _resultValue.deprecatedLastTimestamp = this.deprecatedLastTimestamp;
            _resultValue.deprecatedSource = this.deprecatedSource;
            _resultValue.eventTime = this.eventTime;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.note = this.note;
            _resultValue.reason = this.reason;
            _resultValue.regarding = this.regarding;
            _resultValue.related = this.related;
            _resultValue.reportingController = this.reportingController;
            _resultValue.reportingInstance = this.reportingInstance;
            _resultValue.series = this.series;
            _resultValue.type = this.type;
            return _resultValue;
        }
    }
}

