/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.extensions.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.PodTemplateSpec;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.DaemonSetUpdateStrategy;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DaemonSetSpec {
    @Nullable
    private Integer minReadySeconds;
    @Nullable
    private Integer revisionHistoryLimit;
    @Nullable
    private LabelSelector selector;
    private PodTemplateSpec template;
    @Nullable
    private Integer templateGeneration;
    @Nullable
    private DaemonSetUpdateStrategy updateStrategy;

    private DaemonSetSpec() {
    }

    public Optional<Integer> minReadySeconds() {
        return Optional.ofNullable(this.minReadySeconds);
    }

    public Optional<Integer> revisionHistoryLimit() {
        return Optional.ofNullable(this.revisionHistoryLimit);
    }

    public Optional<LabelSelector> selector() {
        return Optional.ofNullable(this.selector);
    }

    public PodTemplateSpec template() {
        return this.template;
    }

    public Optional<Integer> templateGeneration() {
        return Optional.ofNullable(this.templateGeneration);
    }

    public Optional<DaemonSetUpdateStrategy> updateStrategy() {
        return Optional.ofNullable(this.updateStrategy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DaemonSetSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer minReadySeconds;
        @Nullable
        private Integer revisionHistoryLimit;
        @Nullable
        private LabelSelector selector;
        private PodTemplateSpec template;
        @Nullable
        private Integer templateGeneration;
        @Nullable
        private DaemonSetUpdateStrategy updateStrategy;

        public Builder() {
        }

        public Builder(DaemonSetSpec defaults) {
            Objects.requireNonNull(defaults);
            this.minReadySeconds = defaults.minReadySeconds;
            this.revisionHistoryLimit = defaults.revisionHistoryLimit;
            this.selector = defaults.selector;
            this.template = defaults.template;
            this.templateGeneration = defaults.templateGeneration;
            this.updateStrategy = defaults.updateStrategy;
        }

        @CustomType.Setter
        public Builder minReadySeconds(@Nullable Integer minReadySeconds) {
            this.minReadySeconds = minReadySeconds;
            return this;
        }

        @CustomType.Setter
        public Builder revisionHistoryLimit(@Nullable Integer revisionHistoryLimit) {
            this.revisionHistoryLimit = revisionHistoryLimit;
            return this;
        }

        @CustomType.Setter
        public Builder selector(@Nullable LabelSelector selector) {
            this.selector = selector;
            return this;
        }

        @CustomType.Setter
        public Builder template(PodTemplateSpec template) {
            if (template == null) {
                throw new MissingRequiredPropertyException("DaemonSetSpec", "template");
            }
            this.template = template;
            return this;
        }

        @CustomType.Setter
        public Builder templateGeneration(@Nullable Integer templateGeneration) {
            this.templateGeneration = templateGeneration;
            return this;
        }

        @CustomType.Setter
        public Builder updateStrategy(@Nullable DaemonSetUpdateStrategy updateStrategy) {
            this.updateStrategy = updateStrategy;
            return this;
        }

        public DaemonSetSpec build() {
            DaemonSetSpec _resultValue = new DaemonSetSpec();
            _resultValue.minReadySeconds = this.minReadySeconds;
            _resultValue.revisionHistoryLimit = this.revisionHistoryLimit;
            _resultValue.selector = this.selector;
            _resultValue.template = this.template;
            _resultValue.templateGeneration = this.templateGeneration;
            _resultValue.updateStrategy = this.updateStrategy;
            return _resultValue;
        }
    }
}

