/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.extensions.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.PodTemplateSpec;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.DeploymentStrategy;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.RollbackConfig;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DeploymentSpec {
    @Nullable
    private Integer minReadySeconds;
    @Nullable
    private Boolean paused;
    @Nullable
    private Integer progressDeadlineSeconds;
    @Nullable
    private Integer replicas;
    @Nullable
    private Integer revisionHistoryLimit;
    @Nullable
    private RollbackConfig rollbackTo;
    @Nullable
    private LabelSelector selector;
    @Nullable
    private DeploymentStrategy strategy;
    private PodTemplateSpec template;

    private DeploymentSpec() {
    }

    public Optional<Integer> minReadySeconds() {
        return Optional.ofNullable(this.minReadySeconds);
    }

    public Optional<Boolean> paused() {
        return Optional.ofNullable(this.paused);
    }

    public Optional<Integer> progressDeadlineSeconds() {
        return Optional.ofNullable(this.progressDeadlineSeconds);
    }

    public Optional<Integer> replicas() {
        return Optional.ofNullable(this.replicas);
    }

    public Optional<Integer> revisionHistoryLimit() {
        return Optional.ofNullable(this.revisionHistoryLimit);
    }

    public Optional<RollbackConfig> rollbackTo() {
        return Optional.ofNullable(this.rollbackTo);
    }

    public Optional<LabelSelector> selector() {
        return Optional.ofNullable(this.selector);
    }

    public Optional<DeploymentStrategy> strategy() {
        return Optional.ofNullable(this.strategy);
    }

    public PodTemplateSpec template() {
        return this.template;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DeploymentSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer minReadySeconds;
        @Nullable
        private Boolean paused;
        @Nullable
        private Integer progressDeadlineSeconds;
        @Nullable
        private Integer replicas;
        @Nullable
        private Integer revisionHistoryLimit;
        @Nullable
        private RollbackConfig rollbackTo;
        @Nullable
        private LabelSelector selector;
        @Nullable
        private DeploymentStrategy strategy;
        private PodTemplateSpec template;

        public Builder() {
        }

        public Builder(DeploymentSpec defaults) {
            Objects.requireNonNull(defaults);
            this.minReadySeconds = defaults.minReadySeconds;
            this.paused = defaults.paused;
            this.progressDeadlineSeconds = defaults.progressDeadlineSeconds;
            this.replicas = defaults.replicas;
            this.revisionHistoryLimit = defaults.revisionHistoryLimit;
            this.rollbackTo = defaults.rollbackTo;
            this.selector = defaults.selector;
            this.strategy = defaults.strategy;
            this.template = defaults.template;
        }

        @CustomType.Setter
        public Builder minReadySeconds(@Nullable Integer minReadySeconds) {
            this.minReadySeconds = minReadySeconds;
            return this;
        }

        @CustomType.Setter
        public Builder paused(@Nullable Boolean paused) {
            this.paused = paused;
            return this;
        }

        @CustomType.Setter
        public Builder progressDeadlineSeconds(@Nullable Integer progressDeadlineSeconds) {
            this.progressDeadlineSeconds = progressDeadlineSeconds;
            return this;
        }

        @CustomType.Setter
        public Builder replicas(@Nullable Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        @CustomType.Setter
        public Builder revisionHistoryLimit(@Nullable Integer revisionHistoryLimit) {
            this.revisionHistoryLimit = revisionHistoryLimit;
            return this;
        }

        @CustomType.Setter
        public Builder rollbackTo(@Nullable RollbackConfig rollbackTo) {
            this.rollbackTo = rollbackTo;
            return this;
        }

        @CustomType.Setter
        public Builder selector(@Nullable LabelSelector selector) {
            this.selector = selector;
            return this;
        }

        @CustomType.Setter
        public Builder strategy(@Nullable DeploymentStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        @CustomType.Setter
        public Builder template(PodTemplateSpec template) {
            if (template == null) {
                throw new MissingRequiredPropertyException("DeploymentSpec", "template");
            }
            this.template = template;
            return this;
        }

        public DeploymentSpec build() {
            DeploymentSpec _resultValue = new DeploymentSpec();
            _resultValue.minReadySeconds = this.minReadySeconds;
            _resultValue.paused = this.paused;
            _resultValue.progressDeadlineSeconds = this.progressDeadlineSeconds;
            _resultValue.replicas = this.replicas;
            _resultValue.revisionHistoryLimit = this.revisionHistoryLimit;
            _resultValue.rollbackTo = this.rollbackTo;
            _resultValue.selector = this.selector;
            _resultValue.strategy = this.strategy;
            _resultValue.template = this.template;
            return _resultValue;
        }
    }
}

