/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.extensions.v1beta1.outputs;

import com.pulumi.core.Either;
import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.TypedLocalObjectReference;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class IngressBackend {
    @Nullable
    private TypedLocalObjectReference resource;
    private String serviceName;
    private Either<Integer, String> servicePort;

    private IngressBackend() {
    }

    public Optional<TypedLocalObjectReference> resource() {
        return Optional.ofNullable(this.resource);
    }

    public String serviceName() {
        return this.serviceName;
    }

    public Either<Integer, String> servicePort() {
        return this.servicePort;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IngressBackend defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private TypedLocalObjectReference resource;
        private String serviceName;
        private Either<Integer, String> servicePort;

        public Builder() {
        }

        public Builder(IngressBackend defaults) {
            Objects.requireNonNull(defaults);
            this.resource = defaults.resource;
            this.serviceName = defaults.serviceName;
            this.servicePort = defaults.servicePort;
        }

        @CustomType.Setter
        public Builder resource(@Nullable TypedLocalObjectReference resource) {
            this.resource = resource;
            return this;
        }

        @CustomType.Setter
        public Builder serviceName(String serviceName) {
            if (serviceName == null) {
                throw new MissingRequiredPropertyException("IngressBackend", "serviceName");
            }
            this.serviceName = serviceName;
            return this;
        }

        @CustomType.Setter
        public Builder servicePort(Either<Integer, String> servicePort) {
            if (servicePort == null) {
                throw new MissingRequiredPropertyException("IngressBackend", "servicePort");
            }
            this.servicePort = servicePort;
            return this;
        }

        public IngressBackend build() {
            IngressBackend _resultValue = new IngressBackend();
            _resultValue.resource = this.resource;
            _resultValue.serviceName = this.serviceName;
            _resultValue.servicePort = this.servicePort;
            return _resultValue;
        }
    }
}

