/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.extensions.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.IngressBackend;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.IngressRule;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.IngressTLS;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class IngressSpec {
    @Nullable
    private IngressBackend backend;
    @Nullable
    private String ingressClassName;
    @Nullable
    private List<IngressRule> rules;
    @Nullable
    private List<IngressTLS> tls;

    private IngressSpec() {
    }

    public Optional<IngressBackend> backend() {
        return Optional.ofNullable(this.backend);
    }

    public Optional<String> ingressClassName() {
        return Optional.ofNullable(this.ingressClassName);
    }

    public List<IngressRule> rules() {
        return this.rules == null ? List.of() : this.rules;
    }

    public List<IngressTLS> tls() {
        return this.tls == null ? List.of() : this.tls;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IngressSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private IngressBackend backend;
        @Nullable
        private String ingressClassName;
        @Nullable
        private List<IngressRule> rules;
        @Nullable
        private List<IngressTLS> tls;

        public Builder() {
        }

        public Builder(IngressSpec defaults) {
            Objects.requireNonNull(defaults);
            this.backend = defaults.backend;
            this.ingressClassName = defaults.ingressClassName;
            this.rules = defaults.rules;
            this.tls = defaults.tls;
        }

        @CustomType.Setter
        public Builder backend(@Nullable IngressBackend backend) {
            this.backend = backend;
            return this;
        }

        @CustomType.Setter
        public Builder ingressClassName(@Nullable String ingressClassName) {
            this.ingressClassName = ingressClassName;
            return this;
        }

        @CustomType.Setter
        public Builder rules(@Nullable List<IngressRule> rules) {
            this.rules = rules;
            return this;
        }

        public Builder rules(IngressRule ... rules) {
            return this.rules(List.of(rules));
        }

        @CustomType.Setter
        public Builder tls(@Nullable List<IngressTLS> tls) {
            this.tls = tls;
            return this;
        }

        public Builder tls(IngressTLS ... tls) {
            return this.tls(List.of(tls));
        }

        public IngressSpec build() {
            IngressSpec _resultValue = new IngressSpec();
            _resultValue.backend = this.backend;
            _resultValue.ingressClassName = this.ingressClassName;
            _resultValue.rules = this.rules;
            _resultValue.tls = this.tls;
            return _resultValue;
        }
    }
}

