/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.extensions.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.NetworkPolicyEgressRule;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.NetworkPolicyIngressRule;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@CustomType
public final class NetworkPolicySpec {
    @Nullable
    private List<NetworkPolicyEgressRule> egress;
    @Nullable
    private List<NetworkPolicyIngressRule> ingress;
    private LabelSelector podSelector;
    @Nullable
    private List<String> policyTypes;

    private NetworkPolicySpec() {
    }

    public List<NetworkPolicyEgressRule> egress() {
        return this.egress == null ? List.of() : this.egress;
    }

    public List<NetworkPolicyIngressRule> ingress() {
        return this.ingress == null ? List.of() : this.ingress;
    }

    public LabelSelector podSelector() {
        return this.podSelector;
    }

    public List<String> policyTypes() {
        return this.policyTypes == null ? List.of() : this.policyTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(NetworkPolicySpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<NetworkPolicyEgressRule> egress;
        @Nullable
        private List<NetworkPolicyIngressRule> ingress;
        private LabelSelector podSelector;
        @Nullable
        private List<String> policyTypes;

        public Builder() {
        }

        public Builder(NetworkPolicySpec defaults) {
            Objects.requireNonNull(defaults);
            this.egress = defaults.egress;
            this.ingress = defaults.ingress;
            this.podSelector = defaults.podSelector;
            this.policyTypes = defaults.policyTypes;
        }

        @CustomType.Setter
        public Builder egress(@Nullable List<NetworkPolicyEgressRule> egress) {
            this.egress = egress;
            return this;
        }

        public Builder egress(NetworkPolicyEgressRule ... egress) {
            return this.egress(List.of(egress));
        }

        @CustomType.Setter
        public Builder ingress(@Nullable List<NetworkPolicyIngressRule> ingress) {
            this.ingress = ingress;
            return this;
        }

        public Builder ingress(NetworkPolicyIngressRule ... ingress) {
            return this.ingress(List.of(ingress));
        }

        @CustomType.Setter
        public Builder podSelector(LabelSelector podSelector) {
            if (podSelector == null) {
                throw new MissingRequiredPropertyException("NetworkPolicySpec", "podSelector");
            }
            this.podSelector = podSelector;
            return this;
        }

        @CustomType.Setter
        public Builder policyTypes(@Nullable List<String> policyTypes) {
            this.policyTypes = policyTypes;
            return this;
        }

        public Builder policyTypes(String ... policyTypes) {
            return this.policyTypes(List.of(policyTypes));
        }

        public NetworkPolicySpec build() {
            NetworkPolicySpec _resultValue = new NetworkPolicySpec();
            _resultValue.egress = this.egress;
            _resultValue.ingress = this.ingress;
            _resultValue.podSelector = this.podSelector;
            _resultValue.policyTypes = this.policyTypes;
            return _resultValue;
        }
    }
}

