/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.extensions.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.AllowedCSIDriver;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.AllowedFlexVolume;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.AllowedHostPath;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.FSGroupStrategyOptions;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.HostPortRange;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.RunAsGroupStrategyOptions;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.RunAsUserStrategyOptions;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.RuntimeClassStrategyOptions;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.SELinuxStrategyOptions;
import com.pulumi.kubernetes.extensions.v1beta1.outputs.SupplementalGroupsStrategyOptions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PodSecurityPolicySpec {
    @Nullable
    private Boolean allowPrivilegeEscalation;
    @Nullable
    private List<AllowedCSIDriver> allowedCSIDrivers;
    @Nullable
    private List<String> allowedCapabilities;
    @Nullable
    private List<AllowedFlexVolume> allowedFlexVolumes;
    @Nullable
    private List<AllowedHostPath> allowedHostPaths;
    @Nullable
    private List<String> allowedProcMountTypes;
    @Nullable
    private List<String> allowedUnsafeSysctls;
    @Nullable
    private List<String> defaultAddCapabilities;
    @Nullable
    private Boolean defaultAllowPrivilegeEscalation;
    @Nullable
    private List<String> forbiddenSysctls;
    private FSGroupStrategyOptions fsGroup;
    @Nullable
    private Boolean hostIPC;
    @Nullable
    private Boolean hostNetwork;
    @Nullable
    private Boolean hostPID;
    @Nullable
    private List<HostPortRange> hostPorts;
    @Nullable
    private Boolean privileged;
    @Nullable
    private Boolean readOnlyRootFilesystem;
    @Nullable
    private List<String> requiredDropCapabilities;
    @Nullable
    private RunAsGroupStrategyOptions runAsGroup;
    private RunAsUserStrategyOptions runAsUser;
    @Nullable
    private RuntimeClassStrategyOptions runtimeClass;
    private SELinuxStrategyOptions seLinux;
    private SupplementalGroupsStrategyOptions supplementalGroups;
    @Nullable
    private List<String> volumes;

    private PodSecurityPolicySpec() {
    }

    public Optional<Boolean> allowPrivilegeEscalation() {
        return Optional.ofNullable(this.allowPrivilegeEscalation);
    }

    public List<AllowedCSIDriver> allowedCSIDrivers() {
        return this.allowedCSIDrivers == null ? List.of() : this.allowedCSIDrivers;
    }

    public List<String> allowedCapabilities() {
        return this.allowedCapabilities == null ? List.of() : this.allowedCapabilities;
    }

    public List<AllowedFlexVolume> allowedFlexVolumes() {
        return this.allowedFlexVolumes == null ? List.of() : this.allowedFlexVolumes;
    }

    public List<AllowedHostPath> allowedHostPaths() {
        return this.allowedHostPaths == null ? List.of() : this.allowedHostPaths;
    }

    public List<String> allowedProcMountTypes() {
        return this.allowedProcMountTypes == null ? List.of() : this.allowedProcMountTypes;
    }

    public List<String> allowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls == null ? List.of() : this.allowedUnsafeSysctls;
    }

    public List<String> defaultAddCapabilities() {
        return this.defaultAddCapabilities == null ? List.of() : this.defaultAddCapabilities;
    }

    public Optional<Boolean> defaultAllowPrivilegeEscalation() {
        return Optional.ofNullable(this.defaultAllowPrivilegeEscalation);
    }

    public List<String> forbiddenSysctls() {
        return this.forbiddenSysctls == null ? List.of() : this.forbiddenSysctls;
    }

    public FSGroupStrategyOptions fsGroup() {
        return this.fsGroup;
    }

    public Optional<Boolean> hostIPC() {
        return Optional.ofNullable(this.hostIPC);
    }

    public Optional<Boolean> hostNetwork() {
        return Optional.ofNullable(this.hostNetwork);
    }

    public Optional<Boolean> hostPID() {
        return Optional.ofNullable(this.hostPID);
    }

    public List<HostPortRange> hostPorts() {
        return this.hostPorts == null ? List.of() : this.hostPorts;
    }

    public Optional<Boolean> privileged() {
        return Optional.ofNullable(this.privileged);
    }

    public Optional<Boolean> readOnlyRootFilesystem() {
        return Optional.ofNullable(this.readOnlyRootFilesystem);
    }

    public List<String> requiredDropCapabilities() {
        return this.requiredDropCapabilities == null ? List.of() : this.requiredDropCapabilities;
    }

    public Optional<RunAsGroupStrategyOptions> runAsGroup() {
        return Optional.ofNullable(this.runAsGroup);
    }

    public RunAsUserStrategyOptions runAsUser() {
        return this.runAsUser;
    }

    public Optional<RuntimeClassStrategyOptions> runtimeClass() {
        return Optional.ofNullable(this.runtimeClass);
    }

    public SELinuxStrategyOptions seLinux() {
        return this.seLinux;
    }

    public SupplementalGroupsStrategyOptions supplementalGroups() {
        return this.supplementalGroups;
    }

    public List<String> volumes() {
        return this.volumes == null ? List.of() : this.volumes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PodSecurityPolicySpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean allowPrivilegeEscalation;
        @Nullable
        private List<AllowedCSIDriver> allowedCSIDrivers;
        @Nullable
        private List<String> allowedCapabilities;
        @Nullable
        private List<AllowedFlexVolume> allowedFlexVolumes;
        @Nullable
        private List<AllowedHostPath> allowedHostPaths;
        @Nullable
        private List<String> allowedProcMountTypes;
        @Nullable
        private List<String> allowedUnsafeSysctls;
        @Nullable
        private List<String> defaultAddCapabilities;
        @Nullable
        private Boolean defaultAllowPrivilegeEscalation;
        @Nullable
        private List<String> forbiddenSysctls;
        private FSGroupStrategyOptions fsGroup;
        @Nullable
        private Boolean hostIPC;
        @Nullable
        private Boolean hostNetwork;
        @Nullable
        private Boolean hostPID;
        @Nullable
        private List<HostPortRange> hostPorts;
        @Nullable
        private Boolean privileged;
        @Nullable
        private Boolean readOnlyRootFilesystem;
        @Nullable
        private List<String> requiredDropCapabilities;
        @Nullable
        private RunAsGroupStrategyOptions runAsGroup;
        private RunAsUserStrategyOptions runAsUser;
        @Nullable
        private RuntimeClassStrategyOptions runtimeClass;
        private SELinuxStrategyOptions seLinux;
        private SupplementalGroupsStrategyOptions supplementalGroups;
        @Nullable
        private List<String> volumes;

        public Builder() {
        }

        public Builder(PodSecurityPolicySpec defaults) {
            Objects.requireNonNull(defaults);
            this.allowPrivilegeEscalation = defaults.allowPrivilegeEscalation;
            this.allowedCSIDrivers = defaults.allowedCSIDrivers;
            this.allowedCapabilities = defaults.allowedCapabilities;
            this.allowedFlexVolumes = defaults.allowedFlexVolumes;
            this.allowedHostPaths = defaults.allowedHostPaths;
            this.allowedProcMountTypes = defaults.allowedProcMountTypes;
            this.allowedUnsafeSysctls = defaults.allowedUnsafeSysctls;
            this.defaultAddCapabilities = defaults.defaultAddCapabilities;
            this.defaultAllowPrivilegeEscalation = defaults.defaultAllowPrivilegeEscalation;
            this.forbiddenSysctls = defaults.forbiddenSysctls;
            this.fsGroup = defaults.fsGroup;
            this.hostIPC = defaults.hostIPC;
            this.hostNetwork = defaults.hostNetwork;
            this.hostPID = defaults.hostPID;
            this.hostPorts = defaults.hostPorts;
            this.privileged = defaults.privileged;
            this.readOnlyRootFilesystem = defaults.readOnlyRootFilesystem;
            this.requiredDropCapabilities = defaults.requiredDropCapabilities;
            this.runAsGroup = defaults.runAsGroup;
            this.runAsUser = defaults.runAsUser;
            this.runtimeClass = defaults.runtimeClass;
            this.seLinux = defaults.seLinux;
            this.supplementalGroups = defaults.supplementalGroups;
            this.volumes = defaults.volumes;
        }

        @CustomType.Setter
        public Builder allowPrivilegeEscalation(@Nullable Boolean allowPrivilegeEscalation) {
            this.allowPrivilegeEscalation = allowPrivilegeEscalation;
            return this;
        }

        @CustomType.Setter
        public Builder allowedCSIDrivers(@Nullable List<AllowedCSIDriver> allowedCSIDrivers) {
            this.allowedCSIDrivers = allowedCSIDrivers;
            return this;
        }

        public Builder allowedCSIDrivers(AllowedCSIDriver ... allowedCSIDrivers) {
            return this.allowedCSIDrivers(List.of(allowedCSIDrivers));
        }

        @CustomType.Setter
        public Builder allowedCapabilities(@Nullable List<String> allowedCapabilities) {
            this.allowedCapabilities = allowedCapabilities;
            return this;
        }

        public Builder allowedCapabilities(String ... allowedCapabilities) {
            return this.allowedCapabilities(List.of(allowedCapabilities));
        }

        @CustomType.Setter
        public Builder allowedFlexVolumes(@Nullable List<AllowedFlexVolume> allowedFlexVolumes) {
            this.allowedFlexVolumes = allowedFlexVolumes;
            return this;
        }

        public Builder allowedFlexVolumes(AllowedFlexVolume ... allowedFlexVolumes) {
            return this.allowedFlexVolumes(List.of(allowedFlexVolumes));
        }

        @CustomType.Setter
        public Builder allowedHostPaths(@Nullable List<AllowedHostPath> allowedHostPaths) {
            this.allowedHostPaths = allowedHostPaths;
            return this;
        }

        public Builder allowedHostPaths(AllowedHostPath ... allowedHostPaths) {
            return this.allowedHostPaths(List.of(allowedHostPaths));
        }

        @CustomType.Setter
        public Builder allowedProcMountTypes(@Nullable List<String> allowedProcMountTypes) {
            this.allowedProcMountTypes = allowedProcMountTypes;
            return this;
        }

        public Builder allowedProcMountTypes(String ... allowedProcMountTypes) {
            return this.allowedProcMountTypes(List.of(allowedProcMountTypes));
        }

        @CustomType.Setter
        public Builder allowedUnsafeSysctls(@Nullable List<String> allowedUnsafeSysctls) {
            this.allowedUnsafeSysctls = allowedUnsafeSysctls;
            return this;
        }

        public Builder allowedUnsafeSysctls(String ... allowedUnsafeSysctls) {
            return this.allowedUnsafeSysctls(List.of(allowedUnsafeSysctls));
        }

        @CustomType.Setter
        public Builder defaultAddCapabilities(@Nullable List<String> defaultAddCapabilities) {
            this.defaultAddCapabilities = defaultAddCapabilities;
            return this;
        }

        public Builder defaultAddCapabilities(String ... defaultAddCapabilities) {
            return this.defaultAddCapabilities(List.of(defaultAddCapabilities));
        }

        @CustomType.Setter
        public Builder defaultAllowPrivilegeEscalation(@Nullable Boolean defaultAllowPrivilegeEscalation) {
            this.defaultAllowPrivilegeEscalation = defaultAllowPrivilegeEscalation;
            return this;
        }

        @CustomType.Setter
        public Builder forbiddenSysctls(@Nullable List<String> forbiddenSysctls) {
            this.forbiddenSysctls = forbiddenSysctls;
            return this;
        }

        public Builder forbiddenSysctls(String ... forbiddenSysctls) {
            return this.forbiddenSysctls(List.of(forbiddenSysctls));
        }

        @CustomType.Setter
        public Builder fsGroup(FSGroupStrategyOptions fsGroup) {
            if (fsGroup == null) {
                throw new MissingRequiredPropertyException("PodSecurityPolicySpec", "fsGroup");
            }
            this.fsGroup = fsGroup;
            return this;
        }

        @CustomType.Setter
        public Builder hostIPC(@Nullable Boolean hostIPC) {
            this.hostIPC = hostIPC;
            return this;
        }

        @CustomType.Setter
        public Builder hostNetwork(@Nullable Boolean hostNetwork) {
            this.hostNetwork = hostNetwork;
            return this;
        }

        @CustomType.Setter
        public Builder hostPID(@Nullable Boolean hostPID) {
            this.hostPID = hostPID;
            return this;
        }

        @CustomType.Setter
        public Builder hostPorts(@Nullable List<HostPortRange> hostPorts) {
            this.hostPorts = hostPorts;
            return this;
        }

        public Builder hostPorts(HostPortRange ... hostPorts) {
            return this.hostPorts(List.of(hostPorts));
        }

        @CustomType.Setter
        public Builder privileged(@Nullable Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        @CustomType.Setter
        public Builder readOnlyRootFilesystem(@Nullable Boolean readOnlyRootFilesystem) {
            this.readOnlyRootFilesystem = readOnlyRootFilesystem;
            return this;
        }

        @CustomType.Setter
        public Builder requiredDropCapabilities(@Nullable List<String> requiredDropCapabilities) {
            this.requiredDropCapabilities = requiredDropCapabilities;
            return this;
        }

        public Builder requiredDropCapabilities(String ... requiredDropCapabilities) {
            return this.requiredDropCapabilities(List.of(requiredDropCapabilities));
        }

        @CustomType.Setter
        public Builder runAsGroup(@Nullable RunAsGroupStrategyOptions runAsGroup) {
            this.runAsGroup = runAsGroup;
            return this;
        }

        @CustomType.Setter
        public Builder runAsUser(RunAsUserStrategyOptions runAsUser) {
            if (runAsUser == null) {
                throw new MissingRequiredPropertyException("PodSecurityPolicySpec", "runAsUser");
            }
            this.runAsUser = runAsUser;
            return this;
        }

        @CustomType.Setter
        public Builder runtimeClass(@Nullable RuntimeClassStrategyOptions runtimeClass) {
            this.runtimeClass = runtimeClass;
            return this;
        }

        @CustomType.Setter
        public Builder seLinux(SELinuxStrategyOptions seLinux) {
            if (seLinux == null) {
                throw new MissingRequiredPropertyException("PodSecurityPolicySpec", "seLinux");
            }
            this.seLinux = seLinux;
            return this;
        }

        @CustomType.Setter
        public Builder supplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
            if (supplementalGroups == null) {
                throw new MissingRequiredPropertyException("PodSecurityPolicySpec", "supplementalGroups");
            }
            this.supplementalGroups = supplementalGroups;
            return this;
        }

        @CustomType.Setter
        public Builder volumes(@Nullable List<String> volumes) {
            this.volumes = volumes;
            return this;
        }

        public Builder volumes(String ... volumes) {
            return this.volumes(List.of(volumes));
        }

        public PodSecurityPolicySpec build() {
            PodSecurityPolicySpec _resultValue = new PodSecurityPolicySpec();
            _resultValue.allowPrivilegeEscalation = this.allowPrivilegeEscalation;
            _resultValue.allowedCSIDrivers = this.allowedCSIDrivers;
            _resultValue.allowedCapabilities = this.allowedCapabilities;
            _resultValue.allowedFlexVolumes = this.allowedFlexVolumes;
            _resultValue.allowedHostPaths = this.allowedHostPaths;
            _resultValue.allowedProcMountTypes = this.allowedProcMountTypes;
            _resultValue.allowedUnsafeSysctls = this.allowedUnsafeSysctls;
            _resultValue.defaultAddCapabilities = this.defaultAddCapabilities;
            _resultValue.defaultAllowPrivilegeEscalation = this.defaultAllowPrivilegeEscalation;
            _resultValue.forbiddenSysctls = this.forbiddenSysctls;
            _resultValue.fsGroup = this.fsGroup;
            _resultValue.hostIPC = this.hostIPC;
            _resultValue.hostNetwork = this.hostNetwork;
            _resultValue.hostPID = this.hostPID;
            _resultValue.hostPorts = this.hostPorts;
            _resultValue.privileged = this.privileged;
            _resultValue.readOnlyRootFilesystem = this.readOnlyRootFilesystem;
            _resultValue.requiredDropCapabilities = this.requiredDropCapabilities;
            _resultValue.runAsGroup = this.runAsGroup;
            _resultValue.runAsUser = this.runAsUser;
            _resultValue.runtimeClass = this.runtimeClass;
            _resultValue.seLinux = this.seLinux;
            _resultValue.supplementalGroups = this.supplementalGroups;
            _resultValue.volumes = this.volumes;
            return _resultValue;
        }
    }
}

