/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.extensions.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class RuntimeClassStrategyOptions {
    private List<String> allowedRuntimeClassNames;
    @Nullable
    private String defaultRuntimeClassName;

    private RuntimeClassStrategyOptions() {
    }

    public List<String> allowedRuntimeClassNames() {
        return this.allowedRuntimeClassNames;
    }

    public Optional<String> defaultRuntimeClassName() {
        return Optional.ofNullable(this.defaultRuntimeClassName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RuntimeClassStrategyOptions defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> allowedRuntimeClassNames;
        @Nullable
        private String defaultRuntimeClassName;

        public Builder() {
        }

        public Builder(RuntimeClassStrategyOptions defaults) {
            Objects.requireNonNull(defaults);
            this.allowedRuntimeClassNames = defaults.allowedRuntimeClassNames;
            this.defaultRuntimeClassName = defaults.defaultRuntimeClassName;
        }

        @CustomType.Setter
        public Builder allowedRuntimeClassNames(List<String> allowedRuntimeClassNames) {
            if (allowedRuntimeClassNames == null) {
                throw new MissingRequiredPropertyException("RuntimeClassStrategyOptions", "allowedRuntimeClassNames");
            }
            this.allowedRuntimeClassNames = allowedRuntimeClassNames;
            return this;
        }

        public Builder allowedRuntimeClassNames(String ... allowedRuntimeClassNames) {
            return this.allowedRuntimeClassNames(List.of(allowedRuntimeClassNames));
        }

        @CustomType.Setter
        public Builder defaultRuntimeClassName(@Nullable String defaultRuntimeClassName) {
            this.defaultRuntimeClassName = defaultRuntimeClassName;
            return this;
        }

        public RuntimeClassStrategyOptions build() {
            RuntimeClassStrategyOptions _resultValue = new RuntimeClassStrategyOptions();
            _resultValue.allowedRuntimeClassNames = this.allowedRuntimeClassNames;
            _resultValue.defaultRuntimeClassName = this.defaultRuntimeClassName;
            return _resultValue;
        }
    }
}

