/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.flowcontrol.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.flowcontrol.v1.outputs.FlowDistinguisherMethod;
import com.pulumi.kubernetes.flowcontrol.v1.outputs.PolicyRulesWithSubjects;
import com.pulumi.kubernetes.flowcontrol.v1.outputs.PriorityLevelConfigurationReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class FlowSchemaSpec {
    @Nullable
    private FlowDistinguisherMethod distinguisherMethod;
    @Nullable
    private Integer matchingPrecedence;
    private PriorityLevelConfigurationReference priorityLevelConfiguration;
    @Nullable
    private List<PolicyRulesWithSubjects> rules;

    private FlowSchemaSpec() {
    }

    public Optional<FlowDistinguisherMethod> distinguisherMethod() {
        return Optional.ofNullable(this.distinguisherMethod);
    }

    public Optional<Integer> matchingPrecedence() {
        return Optional.ofNullable(this.matchingPrecedence);
    }

    public PriorityLevelConfigurationReference priorityLevelConfiguration() {
        return this.priorityLevelConfiguration;
    }

    public List<PolicyRulesWithSubjects> rules() {
        return this.rules == null ? List.of() : this.rules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FlowSchemaSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private FlowDistinguisherMethod distinguisherMethod;
        @Nullable
        private Integer matchingPrecedence;
        private PriorityLevelConfigurationReference priorityLevelConfiguration;
        @Nullable
        private List<PolicyRulesWithSubjects> rules;

        public Builder() {
        }

        public Builder(FlowSchemaSpec defaults) {
            Objects.requireNonNull(defaults);
            this.distinguisherMethod = defaults.distinguisherMethod;
            this.matchingPrecedence = defaults.matchingPrecedence;
            this.priorityLevelConfiguration = defaults.priorityLevelConfiguration;
            this.rules = defaults.rules;
        }

        @CustomType.Setter
        public Builder distinguisherMethod(@Nullable FlowDistinguisherMethod distinguisherMethod) {
            this.distinguisherMethod = distinguisherMethod;
            return this;
        }

        @CustomType.Setter
        public Builder matchingPrecedence(@Nullable Integer matchingPrecedence) {
            this.matchingPrecedence = matchingPrecedence;
            return this;
        }

        @CustomType.Setter
        public Builder priorityLevelConfiguration(PriorityLevelConfigurationReference priorityLevelConfiguration) {
            if (priorityLevelConfiguration == null) {
                throw new MissingRequiredPropertyException("FlowSchemaSpec", "priorityLevelConfiguration");
            }
            this.priorityLevelConfiguration = priorityLevelConfiguration;
            return this;
        }

        @CustomType.Setter
        public Builder rules(@Nullable List<PolicyRulesWithSubjects> rules) {
            this.rules = rules;
            return this;
        }

        public Builder rules(PolicyRulesWithSubjects ... rules) {
            return this.rules(List.of(rules));
        }

        public FlowSchemaSpec build() {
            FlowSchemaSpec _resultValue = new FlowSchemaSpec();
            _resultValue.distinguisherMethod = this.distinguisherMethod;
            _resultValue.matchingPrecedence = this.matchingPrecedence;
            _resultValue.priorityLevelConfiguration = this.priorityLevelConfiguration;
            _resultValue.rules = this.rules;
            return _resultValue;
        }
    }
}

