/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.flowcontrol.v1alpha1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.flowcontrol.v1alpha1.outputs.NonResourcePolicyRule;
import com.pulumi.kubernetes.flowcontrol.v1alpha1.outputs.ResourcePolicyRule;
import com.pulumi.kubernetes.flowcontrol.v1alpha1.outputs.Subject;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@CustomType
public final class PolicyRulesWithSubjects {
    @Nullable
    private List<NonResourcePolicyRule> nonResourceRules;
    @Nullable
    private List<ResourcePolicyRule> resourceRules;
    private List<Subject> subjects;

    private PolicyRulesWithSubjects() {
    }

    public List<NonResourcePolicyRule> nonResourceRules() {
        return this.nonResourceRules == null ? List.of() : this.nonResourceRules;
    }

    public List<ResourcePolicyRule> resourceRules() {
        return this.resourceRules == null ? List.of() : this.resourceRules;
    }

    public List<Subject> subjects() {
        return this.subjects;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PolicyRulesWithSubjects defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<NonResourcePolicyRule> nonResourceRules;
        @Nullable
        private List<ResourcePolicyRule> resourceRules;
        private List<Subject> subjects;

        public Builder() {
        }

        public Builder(PolicyRulesWithSubjects defaults) {
            Objects.requireNonNull(defaults);
            this.nonResourceRules = defaults.nonResourceRules;
            this.resourceRules = defaults.resourceRules;
            this.subjects = defaults.subjects;
        }

        @CustomType.Setter
        public Builder nonResourceRules(@Nullable List<NonResourcePolicyRule> nonResourceRules) {
            this.nonResourceRules = nonResourceRules;
            return this;
        }

        public Builder nonResourceRules(NonResourcePolicyRule ... nonResourceRules) {
            return this.nonResourceRules(List.of(nonResourceRules));
        }

        @CustomType.Setter
        public Builder resourceRules(@Nullable List<ResourcePolicyRule> resourceRules) {
            this.resourceRules = resourceRules;
            return this;
        }

        public Builder resourceRules(ResourcePolicyRule ... resourceRules) {
            return this.resourceRules(List.of(resourceRules));
        }

        @CustomType.Setter
        public Builder subjects(List<Subject> subjects) {
            if (subjects == null) {
                throw new MissingRequiredPropertyException("PolicyRulesWithSubjects", "subjects");
            }
            this.subjects = subjects;
            return this;
        }

        public Builder subjects(Subject ... subjects) {
            return this.subjects(List.of(subjects));
        }

        public PolicyRulesWithSubjects build() {
            PolicyRulesWithSubjects _resultValue = new PolicyRulesWithSubjects();
            _resultValue.nonResourceRules = this.nonResourceRules;
            _resultValue.resourceRules = this.resourceRules;
            _resultValue.subjects = this.subjects;
            return _resultValue;
        }
    }
}

