/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.flowcontrol.v1alpha1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.flowcontrol.v1alpha1.outputs.GroupSubject;
import com.pulumi.kubernetes.flowcontrol.v1alpha1.outputs.ServiceAccountSubject;
import com.pulumi.kubernetes.flowcontrol.v1alpha1.outputs.UserSubject;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class Subject {
    @Nullable
    private GroupSubject group;
    private String kind;
    @Nullable
    private ServiceAccountSubject serviceAccount;
    @Nullable
    private UserSubject user;

    private Subject() {
    }

    public Optional<GroupSubject> group() {
        return Optional.ofNullable(this.group);
    }

    public String kind() {
        return this.kind;
    }

    public Optional<ServiceAccountSubject> serviceAccount() {
        return Optional.ofNullable(this.serviceAccount);
    }

    public Optional<UserSubject> user() {
        return Optional.ofNullable(this.user);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Subject defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private GroupSubject group;
        private String kind;
        @Nullable
        private ServiceAccountSubject serviceAccount;
        @Nullable
        private UserSubject user;

        public Builder() {
        }

        public Builder(Subject defaults) {
            Objects.requireNonNull(defaults);
            this.group = defaults.group;
            this.kind = defaults.kind;
            this.serviceAccount = defaults.serviceAccount;
            this.user = defaults.user;
        }

        @CustomType.Setter
        public Builder group(@Nullable GroupSubject group) {
            this.group = group;
            return this;
        }

        @CustomType.Setter
        public Builder kind(String kind) {
            if (kind == null) {
                throw new MissingRequiredPropertyException("Subject", "kind");
            }
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder serviceAccount(@Nullable ServiceAccountSubject serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        @CustomType.Setter
        public Builder user(@Nullable UserSubject user) {
            this.user = user;
            return this;
        }

        public Subject build() {
            Subject _resultValue = new Subject();
            _resultValue.group = this.group;
            _resultValue.kind = this.kind;
            _resultValue.serviceAccount = this.serviceAccount;
            _resultValue.user = this.user;
            return _resultValue;
        }
    }
}

