/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.flowcontrol.v1beta2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ResourcePolicyRule {
    private List<String> apiGroups;
    @Nullable
    private Boolean clusterScope;
    @Nullable
    private List<String> namespaces;
    private List<String> resources;
    private List<String> verbs;

    private ResourcePolicyRule() {
    }

    public List<String> apiGroups() {
        return this.apiGroups;
    }

    public Optional<Boolean> clusterScope() {
        return Optional.ofNullable(this.clusterScope);
    }

    public List<String> namespaces() {
        return this.namespaces == null ? List.of() : this.namespaces;
    }

    public List<String> resources() {
        return this.resources;
    }

    public List<String> verbs() {
        return this.verbs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourcePolicyRule defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> apiGroups;
        @Nullable
        private Boolean clusterScope;
        @Nullable
        private List<String> namespaces;
        private List<String> resources;
        private List<String> verbs;

        public Builder() {
        }

        public Builder(ResourcePolicyRule defaults) {
            Objects.requireNonNull(defaults);
            this.apiGroups = defaults.apiGroups;
            this.clusterScope = defaults.clusterScope;
            this.namespaces = defaults.namespaces;
            this.resources = defaults.resources;
            this.verbs = defaults.verbs;
        }

        @CustomType.Setter
        public Builder apiGroups(List<String> apiGroups) {
            if (apiGroups == null) {
                throw new MissingRequiredPropertyException("ResourcePolicyRule", "apiGroups");
            }
            this.apiGroups = apiGroups;
            return this;
        }

        public Builder apiGroups(String ... apiGroups) {
            return this.apiGroups(List.of(apiGroups));
        }

        @CustomType.Setter
        public Builder clusterScope(@Nullable Boolean clusterScope) {
            this.clusterScope = clusterScope;
            return this;
        }

        @CustomType.Setter
        public Builder namespaces(@Nullable List<String> namespaces) {
            this.namespaces = namespaces;
            return this;
        }

        public Builder namespaces(String ... namespaces) {
            return this.namespaces(List.of(namespaces));
        }

        @CustomType.Setter
        public Builder resources(List<String> resources) {
            if (resources == null) {
                throw new MissingRequiredPropertyException("ResourcePolicyRule", "resources");
            }
            this.resources = resources;
            return this;
        }

        public Builder resources(String ... resources) {
            return this.resources(List.of(resources));
        }

        @CustomType.Setter
        public Builder verbs(List<String> verbs) {
            if (verbs == null) {
                throw new MissingRequiredPropertyException("ResourcePolicyRule", "verbs");
            }
            this.verbs = verbs;
            return this;
        }

        public Builder verbs(String ... verbs) {
            return this.verbs(List.of(verbs));
        }

        public ResourcePolicyRule build() {
            ResourcePolicyRule _resultValue = new ResourcePolicyRule();
            _resultValue.apiGroups = this.apiGroups;
            _resultValue.clusterScope = this.clusterScope;
            _resultValue.namespaces = this.namespaces;
            _resultValue.resources = this.resources;
            _resultValue.verbs = this.verbs;
            return _resultValue;
        }
    }
}

