/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.meta.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class OwnerReference {
    private String apiVersion;
    @Nullable
    private Boolean blockOwnerDeletion;
    @Nullable
    private Boolean controller;
    private String kind;
    private String name;
    private String uid;

    private OwnerReference() {
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public Optional<Boolean> blockOwnerDeletion() {
        return Optional.ofNullable(this.blockOwnerDeletion);
    }

    public Optional<Boolean> controller() {
        return Optional.ofNullable(this.controller);
    }

    public String kind() {
        return this.kind;
    }

    public String name() {
        return this.name;
    }

    public String uid() {
        return this.uid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OwnerReference defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String apiVersion;
        @Nullable
        private Boolean blockOwnerDeletion;
        @Nullable
        private Boolean controller;
        private String kind;
        private String name;
        private String uid;

        public Builder() {
        }

        public Builder(OwnerReference defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.blockOwnerDeletion = defaults.blockOwnerDeletion;
            this.controller = defaults.controller;
            this.kind = defaults.kind;
            this.name = defaults.name;
            this.uid = defaults.uid;
        }

        @CustomType.Setter
        public Builder apiVersion(String apiVersion) {
            if (apiVersion == null) {
                throw new MissingRequiredPropertyException("OwnerReference", "apiVersion");
            }
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder blockOwnerDeletion(@Nullable Boolean blockOwnerDeletion) {
            this.blockOwnerDeletion = blockOwnerDeletion;
            return this;
        }

        @CustomType.Setter
        public Builder controller(@Nullable Boolean controller) {
            this.controller = controller;
            return this;
        }

        @CustomType.Setter
        public Builder kind(String kind) {
            if (kind == null) {
                throw new MissingRequiredPropertyException("OwnerReference", "kind");
            }
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("OwnerReference", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder uid(String uid) {
            if (uid == null) {
                throw new MissingRequiredPropertyException("OwnerReference", "uid");
            }
            this.uid = uid;
            return this;
        }

        public OwnerReference build() {
            OwnerReference _resultValue = new OwnerReference();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.blockOwnerDeletion = this.blockOwnerDeletion;
            _resultValue.controller = this.controller;
            _resultValue.kind = this.kind;
            _resultValue.name = this.name;
            _resultValue.uid = this.uid;
            return _resultValue;
        }
    }
}

