/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.networking.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.networking.v1.outputs.IngressBackend;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class HTTPIngressPath {
    private IngressBackend backend;
    @Nullable
    private String path;
    private String pathType;

    private HTTPIngressPath() {
    }

    public IngressBackend backend() {
        return this.backend;
    }

    public Optional<String> path() {
        return Optional.ofNullable(this.path);
    }

    public String pathType() {
        return this.pathType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HTTPIngressPath defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private IngressBackend backend;
        @Nullable
        private String path;
        private String pathType;

        public Builder() {
        }

        public Builder(HTTPIngressPath defaults) {
            Objects.requireNonNull(defaults);
            this.backend = defaults.backend;
            this.path = defaults.path;
            this.pathType = defaults.pathType;
        }

        @CustomType.Setter
        public Builder backend(IngressBackend backend) {
            if (backend == null) {
                throw new MissingRequiredPropertyException("HTTPIngressPath", "backend");
            }
            this.backend = backend;
            return this;
        }

        @CustomType.Setter
        public Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        @CustomType.Setter
        public Builder pathType(String pathType) {
            if (pathType == null) {
                throw new MissingRequiredPropertyException("HTTPIngressPath", "pathType");
            }
            this.pathType = pathType;
            return this;
        }

        public HTTPIngressPath build() {
            HTTPIngressPath _resultValue = new HTTPIngressPath();
            _resultValue.backend = this.backend;
            _resultValue.path = this.path;
            _resultValue.pathType = this.pathType;
            return _resultValue;
        }
    }
}

