/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.networking.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class IngressClassParametersReference {
    @Nullable
    private String apiGroup;
    private String kind;
    private String name;
    @Nullable
    private String namespace;
    @Nullable
    private String scope;

    private IngressClassParametersReference() {
    }

    public Optional<String> apiGroup() {
        return Optional.ofNullable(this.apiGroup);
    }

    public String kind() {
        return this.kind;
    }

    public String name() {
        return this.name;
    }

    public Optional<String> namespace() {
        return Optional.ofNullable(this.namespace);
    }

    public Optional<String> scope() {
        return Optional.ofNullable(this.scope);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IngressClassParametersReference defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiGroup;
        private String kind;
        private String name;
        @Nullable
        private String namespace;
        @Nullable
        private String scope;

        public Builder() {
        }

        public Builder(IngressClassParametersReference defaults) {
            Objects.requireNonNull(defaults);
            this.apiGroup = defaults.apiGroup;
            this.kind = defaults.kind;
            this.name = defaults.name;
            this.namespace = defaults.namespace;
            this.scope = defaults.scope;
        }

        @CustomType.Setter
        public Builder apiGroup(@Nullable String apiGroup) {
            this.apiGroup = apiGroup;
            return this;
        }

        @CustomType.Setter
        public Builder kind(String kind) {
            if (kind == null) {
                throw new MissingRequiredPropertyException("IngressClassParametersReference", "kind");
            }
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("IngressClassParametersReference", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder namespace(@Nullable String namespace) {
            this.namespace = namespace;
            return this;
        }

        @CustomType.Setter
        public Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        public IngressClassParametersReference build() {
            IngressClassParametersReference _resultValue = new IngressClassParametersReference();
            _resultValue.apiGroup = this.apiGroup;
            _resultValue.kind = this.kind;
            _resultValue.name = this.name;
            _resultValue.namespace = this.namespace;
            _resultValue.scope = this.scope;
            return _resultValue;
        }
    }
}

