/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.networking.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.networking.v1.outputs.IngressBackendPatch;
import com.pulumi.kubernetes.networking.v1.outputs.IngressRulePatch;
import com.pulumi.kubernetes.networking.v1.outputs.IngressTLSPatch;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class IngressSpecPatch {
    @Nullable
    private IngressBackendPatch defaultBackend;
    @Nullable
    private String ingressClassName;
    @Nullable
    private List<IngressRulePatch> rules;
    @Nullable
    private List<IngressTLSPatch> tls;

    private IngressSpecPatch() {
    }

    public Optional<IngressBackendPatch> defaultBackend() {
        return Optional.ofNullable(this.defaultBackend);
    }

    public Optional<String> ingressClassName() {
        return Optional.ofNullable(this.ingressClassName);
    }

    public List<IngressRulePatch> rules() {
        return this.rules == null ? List.of() : this.rules;
    }

    public List<IngressTLSPatch> tls() {
        return this.tls == null ? List.of() : this.tls;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IngressSpecPatch defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private IngressBackendPatch defaultBackend;
        @Nullable
        private String ingressClassName;
        @Nullable
        private List<IngressRulePatch> rules;
        @Nullable
        private List<IngressTLSPatch> tls;

        public Builder() {
        }

        public Builder(IngressSpecPatch defaults) {
            Objects.requireNonNull(defaults);
            this.defaultBackend = defaults.defaultBackend;
            this.ingressClassName = defaults.ingressClassName;
            this.rules = defaults.rules;
            this.tls = defaults.tls;
        }

        @CustomType.Setter
        public Builder defaultBackend(@Nullable IngressBackendPatch defaultBackend) {
            this.defaultBackend = defaultBackend;
            return this;
        }

        @CustomType.Setter
        public Builder ingressClassName(@Nullable String ingressClassName) {
            this.ingressClassName = ingressClassName;
            return this;
        }

        @CustomType.Setter
        public Builder rules(@Nullable List<IngressRulePatch> rules) {
            this.rules = rules;
            return this;
        }

        public Builder rules(IngressRulePatch ... rules) {
            return this.rules(List.of(rules));
        }

        @CustomType.Setter
        public Builder tls(@Nullable List<IngressTLSPatch> tls) {
            this.tls = tls;
            return this;
        }

        public Builder tls(IngressTLSPatch ... tls) {
            return this.tls(List.of(tls));
        }

        public IngressSpecPatch build() {
            IngressSpecPatch _resultValue = new IngressSpecPatch();
            _resultValue.defaultBackend = this.defaultBackend;
            _resultValue.ingressClassName = this.ingressClassName;
            _resultValue.rules = this.rules;
            _resultValue.tls = this.tls;
            return _resultValue;
        }
    }
}

